/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory;

import com.gitee.starblues.factory.SpringBeanRegister;
import com.gitee.starblues.factory.process.pipe.PluginInfoContainers;
import com.gitee.starblues.factory.process.pipe.loader.ResourceWrapper;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.realize.BasePlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;

public class PluginRegistryInfo {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PluginWrapper pluginWrapper;
    private final PluginManager pluginManager;
    private final IntegrationConfiguration configuration;
    private final GenericApplicationContext mainApplicationContext;
    private final AnnotationConfigApplicationContext pluginApplicationContext;
    private final Binder pluginBinder;
    private final SpringBeanRegister springBeanRegister;
    private final boolean followingInitial;
    private final BasePlugin basePlugin;
    private final Map<String, Object> extensionMap = new ConcurrentHashMap<String, Object>();
    private final Set<Object> configSingletonObjects = new HashSet<Object>(4);
    private final List<Class<?>> classes = new ArrayList(8);
    private final Map<String, ResourceWrapper> pluginLoadResources = new ConcurrentHashMap<String, ResourceWrapper>(8);
    private final Map<String, List<Class<?>>> groupClasses = new ConcurrentHashMap(8);
    private final Map<String, Object> processorInfo = new ConcurrentHashMap<String, Object>(8);

    private PluginRegistryInfo(PluginWrapper pluginWrapper, PluginManager pluginManager, GenericApplicationContext mainApplicationContext, boolean followingInitial) {
        this.pluginWrapper = pluginWrapper;
        this.pluginManager = pluginManager;
        this.basePlugin = (BasePlugin)pluginWrapper.getPlugin();
        this.mainApplicationContext = mainApplicationContext;
        this.configuration = (IntegrationConfiguration)mainApplicationContext.getBean(IntegrationConfiguration.class);
        this.followingInitial = followingInitial;
        ClassLoader pluginClassLoader = this.basePlugin.getWrapper().getPluginClassLoader();
        DefaultListableBeanFactory defaultListableBeanFactory = new DefaultListableBeanFactory();
        this.pluginApplicationContext = new AnnotationConfigApplicationContext(defaultListableBeanFactory);
        this.pluginApplicationContext.setClassLoader(pluginClassLoader);
        this.pluginBinder = Binder.get((Environment)this.pluginApplicationContext.getEnvironment());
        this.springBeanRegister = new SpringBeanRegister((GenericApplicationContext)this.pluginApplicationContext);
    }

    public static PluginRegistryInfo build(PluginWrapper pluginWrapper, PluginManager pluginManager, GenericApplicationContext parentApplicationContext, boolean followingInitial) {
        Objects.requireNonNull(pluginWrapper, "PluginWrapper can't is null");
        Objects.requireNonNull(pluginWrapper, "PluginManager can't is null");
        Objects.requireNonNull(pluginWrapper, "parentApplicationContext can't is null");
        return new PluginRegistryInfo(pluginWrapper, pluginManager, parentApplicationContext, followingInitial);
    }

    public PluginWrapper getPluginWrapper() {
        return this.pluginWrapper;
    }

    public BasePlugin getBasePlugin() {
        return this.basePlugin;
    }

    public void addClasses(Class<?> aClass) {
        if (aClass != null) {
            this.classes.add(aClass);
        }
    }

    public void cleanClasses() {
        this.classes.clear();
    }

    public List<Class<?>> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    public void addPluginLoadResource(String key, ResourceWrapper resourceWrapper) {
        if (StringUtils.isNullOrEmpty((String)key)) {
            return;
        }
        if (resourceWrapper == null) {
            return;
        }
        this.pluginLoadResources.put(key, resourceWrapper);
    }

    public ResourceWrapper getPluginLoadResource(String key) {
        return this.pluginLoadResources.get(key);
    }

    public void addGroupClasses(String key, Class<?> aClass) {
        if (StringUtils.isNullOrEmpty((String)key)) {
            return;
        }
        if (aClass == null) {
            return;
        }
        List classes = this.groupClasses.computeIfAbsent(key, k -> new ArrayList());
        classes.add(aClass);
    }

    public List<Class<?>> getGroupClasses(String key) {
        List<Class<?>> classes = this.groupClasses.get(key);
        ArrayList result = new ArrayList();
        if (classes != null) {
            result.addAll(classes);
        }
        return result;
    }

    public <T> T getProcessorInfo(String key) {
        Object o = this.processorInfo.get(key);
        if (o != null) {
            return (T)o;
        }
        return null;
    }

    public void addConfigSingleton(Object singletonObject) {
        this.configSingletonObjects.add(singletonObject);
    }

    public Set<Object> getConfigSingletons() {
        return Collections.unmodifiableSet(this.configSingletonObjects);
    }

    public void addProcessorInfo(String key, Object value) {
        this.processorInfo.put(key, value);
    }

    public void addExtension(String key, Object value) {
        if (this.extensionMap.containsKey(key)) {
            throw new RuntimeException("The extension key ' " + key + " 'already exists");
        }
        this.extensionMap.put(key, value);
    }

    public GenericApplicationContext getMainApplicationContext() {
        return this.mainApplicationContext;
    }

    public GenericApplicationContext getPluginApplicationContext() {
        return this.pluginApplicationContext;
    }

    public Binder getPluginBinder() {
        return this.pluginBinder;
    }

    public SpringBeanRegister getSpringBeanRegister() {
        return this.springBeanRegister;
    }

    public void removeExtension(String key) {
        this.extensionMap.remove(key);
    }

    public <T> T getExtension(String key) {
        Object o = this.extensionMap.get(key);
        if (o == null) {
            return null;
        }
        return (T)o;
    }

    public ClassLoader getPluginClassLoader() {
        return this.pluginWrapper.getPluginClassLoader();
    }

    public boolean isFollowingInitial() {
        return this.followingInitial;
    }

    public IntegrationConfiguration getConfiguration() {
        return this.configuration;
    }

    void destroy() {
        try {
            PluginInfoContainers.removePluginApplicationContext(this.getPluginWrapper().getPluginId());
            this.closePluginApplicationContext();
        }
        catch (Exception e) {
            this.logger.error("Close plugin '{}'-ApplicationContext failure", (Object)this.getPluginWrapper().getPluginId(), (Object)e);
        }
        try {
            this.extensionMap.clear();
            this.classes.clear();
            this.groupClasses.clear();
            this.processorInfo.clear();
            this.pluginLoadResources.clear();
            this.configSingletonObjects.clear();
        }
        catch (Exception e) {
            this.logger.error("Clear plugin '{}' failure", (Object)this.getPluginWrapper().getPluginId(), (Object)e);
        }
    }

    private void closePluginApplicationContext() {
        try {
            this.getSpringBeanRegister().destroySingletons();
            this.pluginApplicationContext.close();
        }
        catch (Exception e) {
            this.logger.error("Close plugin '{}' ApplicationContext failure", (Object)this.getPluginWrapper().getPluginId(), (Object)e);
        }
    }
}

