/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension;

import com.gitee.starblues.extension.AbstractExtension;
import com.gitee.starblues.extension.PluginControllerProcessorExtend;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class ExtensionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionFactory.class);
    private static final Map<String, AbstractExtension> PLUGIN_EXTENSION_MAP = new ConcurrentHashMap<String, AbstractExtension>();

    private ExtensionFactory() {
    }

    public static void addExtension(AbstractExtension abstractExtension) {
        if (abstractExtension == null) {
            LOG.warn("add failure, abstractExtension is null");
            return;
        }
        String key = abstractExtension.key();
        if (StringUtils.isEmpty((Object)key)) {
            LOG.error("add failure, key is empty");
        }
        PLUGIN_EXTENSION_MAP.put(key, abstractExtension);
    }

    public static List<PluginControllerProcessorExtend> getPluginControllerProcessorExtend(ApplicationContext mainApplicationContext) {
        return SpringBeanUtils.getBeans(mainApplicationContext, PluginControllerProcessorExtend.class);
    }

    static Map<String, AbstractExtension> getPluginExtension() {
        return Collections.unmodifiableMap(PLUGIN_EXTENSION_MAP);
    }
}

