/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader;

import com.gitee.starblues.extension.ExtensionInitializer;
import com.gitee.starblues.loader.PluginResourceLoader;
import com.gitee.starblues.loader.ResourceWrapper;
import com.gitee.starblues.loader.load.PluginClassLoader;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.CommonUtils;
import com.gitee.starblues.utils.OrderPriority;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PluginResourceLoadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PluginResourceLoadFactory.class);
    private final Map<String, ResourceWrapper> pluginResourceWrappers = new ConcurrentHashMap<String, ResourceWrapper>();
    private final List<PluginResourceLoader> pluginResourceLoaders = new ArrayList<PluginResourceLoader>(5);

    public PluginResourceLoadFactory() {
        this.pluginResourceLoaders.add(new PluginClassLoader());
        this.pluginResourceLoaders.addAll(ExtensionInitializer.getResourceLoadersExtends());
        CommonUtils.order(this.pluginResourceLoaders, pluginResourceLoader -> {
            OrderPriority order = pluginResourceLoader.order();
            if (order == null) {
                order = OrderPriority.getMiddlePriority();
            }
            return order.getPriority();
        });
    }

    public synchronized void load(BasePlugin basePlugin) {
        for (PluginResourceLoader pluginResourceLoader : this.pluginResourceLoaders) {
            if (pluginResourceLoader == null) continue;
            String key = pluginResourceLoader.key();
            if (StringUtils.isEmpty((Object)key)) {
                LOG.error("pluginResourceLoader {} key is empty, skip!", (Object)pluginResourceLoader.getClass().getName());
                continue;
            }
            try {
                ResourceWrapper resourceWrapper = pluginResourceLoader.load(basePlugin);
                if (resourceWrapper == null) continue;
                this.pluginResourceWrappers.put(key, resourceWrapper);
            }
            catch (Exception e) {
                LOG.error("Plugin resource loader '{}' load error. {}", new Object[]{key, e.getMessage(), e});
            }
        }
    }

    public synchronized void unload(BasePlugin basePlugin) {
        for (PluginResourceLoader pluginResourceLoader : this.pluginResourceLoaders) {
            if (pluginResourceLoader == null) continue;
            String key = pluginResourceLoader.key();
            try {
                ResourceWrapper resourceWrapper = this.pluginResourceWrappers.get(key);
                pluginResourceLoader.unload(basePlugin, resourceWrapper);
            }
            catch (Exception e) {
                LOG.error("Plugin resource loader '{}' unload error. {}", new Object[]{key, e.getMessage(), e});
            }
        }
    }

    public ResourceWrapper getPluginResources(String key) {
        return this.pluginResourceWrappers.get(key);
    }
}

