/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.classs;

import com.gitee.starblues.extension.ExtensionInitializer;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessor;
import com.gitee.starblues.factory.process.pipe.classs.PluginClassGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.CallerGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.ComponentGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.ConfigDefinitionGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.ConfigurationGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.ControllerGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.OneselfListenerGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.RepositoryGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.SupplierGroup;
import com.gitee.starblues.loader.PluginResourceLoadFactory;
import com.gitee.starblues.loader.ResourceWrapper;
import com.gitee.starblues.realize.BasePlugin;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class PluginClassProcess
implements PluginPipeProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String OTHER = "other";
    private final List<PluginClassGroup> pluginClassGroups = new ArrayList<PluginClassGroup>();

    @Override
    public void initialize() {
        this.pluginClassGroups.add(new ComponentGroup());
        this.pluginClassGroups.add(new ControllerGroup());
        this.pluginClassGroups.add(new RepositoryGroup());
        this.pluginClassGroups.add(new ConfigurationGroup());
        this.pluginClassGroups.add(new ConfigDefinitionGroup());
        this.pluginClassGroups.add(new SupplierGroup());
        this.pluginClassGroups.add(new CallerGroup());
        this.pluginClassGroups.add(new OneselfListenerGroup());
        this.pluginClassGroups.addAll(ExtensionInitializer.getClassGroupExtends());
    }

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        PluginResourceLoadFactory pluginResourceLoadFactory = basePlugin.getBasePluginExtend().getPluginResourceLoadFactory();
        ResourceWrapper resourceWrapper = pluginResourceLoadFactory.getPluginResources("PluginClassProcess");
        if (resourceWrapper == null) {
            return;
        }
        List<Resource> pluginResources = resourceWrapper.getResources();
        if (pluginResources == null) {
            return;
        }
        for (PluginClassGroup pluginClassGroup : this.pluginClassGroups) {
            try {
                pluginClassGroup.initialize(basePlugin);
            }
            catch (Exception e) {
                this.log.error("PluginClassGroup {} initialize exception. {}", new Object[]{pluginClassGroup.getClass(), e.getMessage(), e});
            }
        }
        for (Resource pluginResource : pluginResources) {
            String path = pluginResource.getURL().getPath();
            String packageName = path.substring(0, path.indexOf(".class")).replace("/", ".");
            Class<?> aClass = Class.forName(packageName = packageName.substring(packageName.indexOf(basePlugin.scanPackage())), false, basePlugin.getWrapper().getPluginClassLoader());
            if (aClass == null) continue;
            boolean findGroup = false;
            for (PluginClassGroup pluginClassGroup : this.pluginClassGroups) {
                if (pluginClassGroup == null || StringUtils.isEmpty((Object)pluginClassGroup.groupId()) || !pluginClassGroup.filter(aClass)) continue;
                pluginRegistryInfo.addGroupClasses(pluginClassGroup.groupId(), aClass);
                findGroup = true;
            }
            if (!findGroup) {
                pluginRegistryInfo.addGroupClasses(OTHER, aClass);
            }
            pluginRegistryInfo.addClasses(aClass);
        }
    }

    @Override
    public void unRegistry(PluginRegistryInfo registerPluginInfo) throws Exception {
        registerPluginInfo.cleanClasses();
    }
}

