/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory;

import com.gitee.starblues.factory.PluginFactory;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessor;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessorFactory;
import com.gitee.starblues.factory.process.post.PluginPostProcessor;
import com.gitee.starblues.factory.process.post.PluginPostProcessorFactory;
import com.gitee.starblues.integration.listener.PluginListener;
import com.gitee.starblues.integration.listener.PluginListenerFactory;
import com.gitee.starblues.utils.AopUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pf4j.PluginWrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class DefaultPluginFactory
implements PluginFactory {
    private final Map<String, PluginRegistryInfo> registerPluginInfoMap = new HashMap<String, PluginRegistryInfo>();
    private final GenericApplicationContext applicationContext;
    private final PluginPipeProcessor pluginPipeProcessor;
    private final PluginPostProcessor pluginPostProcessor;
    private final PluginListenerFactory pluginListenerFactory;
    private Integer buildType = 0;
    private final List<PluginRegistryInfo> buildContainer = new ArrayList<PluginRegistryInfo>();

    public DefaultPluginFactory(ApplicationContext applicationContext) {
        this(applicationContext, null);
    }

    public DefaultPluginFactory(ApplicationContext applicationContext, PluginListenerFactory pluginListenerFactory) {
        this.pluginPipeProcessor = new PluginPipeProcessorFactory(applicationContext);
        this.pluginPostProcessor = new PluginPostProcessorFactory(applicationContext);
        this.applicationContext = (GenericApplicationContext)applicationContext;
        this.pluginListenerFactory = pluginListenerFactory == null ? new PluginListenerFactory() : pluginListenerFactory;
        AopUtils.registered(applicationContext);
    }

    @Override
    public void initialize() throws Exception {
        this.pluginPipeProcessor.initialize();
        this.pluginPostProcessor.initialize();
    }

    @Override
    public synchronized PluginFactory registry(PluginWrapper pluginWrapper) throws Exception {
        if (pluginWrapper == null) {
            throw new IllegalArgumentException("Parameter:pluginWrapper cannot be null");
        }
        if (this.registerPluginInfoMap.containsKey(pluginWrapper.getPluginId())) {
            throw new IllegalAccessException("The plugin " + pluginWrapper.getPluginId() + "already exists, Can't register");
        }
        if (!this.buildContainer.isEmpty() && this.buildType == 2) {
            throw new IllegalAccessException("Unable to Registry operate. Because there's no build");
        }
        PluginRegistryInfo registerPluginInfo = new PluginRegistryInfo(pluginWrapper);
        AopUtils.resolveAop(pluginWrapper);
        try {
            this.pluginPipeProcessor.registry(registerPluginInfo);
            this.registerPluginInfoMap.put(pluginWrapper.getPluginId(), registerPluginInfo);
            this.buildContainer.add(registerPluginInfo);
            DefaultPluginFactory defaultPluginFactory = this;
            return defaultPluginFactory;
        }
        catch (Exception e) {
            this.pluginListenerFactory.failure(pluginWrapper.getPluginId(), e);
            throw e;
        }
        finally {
            this.buildType = 1;
            AopUtils.recoverAop();
        }
    }

    @Override
    public synchronized PluginFactory unRegistry(String pluginId) throws Exception {
        PluginRegistryInfo registerPluginInfo = this.registerPluginInfoMap.get(pluginId);
        if (registerPluginInfo == null) {
            throw new Exception("Not found plugin " + pluginId + " registered");
        }
        if (!this.buildContainer.isEmpty() && this.buildType == 1) {
            throw new Exception("Unable to UnRegistry operate. Because there's no build");
        }
        try {
            this.pluginPipeProcessor.unRegistry(registerPluginInfo);
            this.buildContainer.add(registerPluginInfo);
            DefaultPluginFactory defaultPluginFactory = this;
            return defaultPluginFactory;
        }
        catch (Exception e) {
            this.pluginListenerFactory.failure(pluginId, e);
            throw e;
        }
        finally {
            this.registerPluginInfoMap.remove(pluginId);
            this.buildType = 2;
        }
    }

    @Override
    public synchronized void build() throws Exception {
        if (this.buildContainer.isEmpty()) {
            throw new Exception("No Found registered or unRegistry plugin. Unable to build");
        }
        this.pluginListenerFactory.buildListenerClass(this.applicationContext);
        try {
            if (this.buildType == 1) {
                this.registryBuild();
            } else {
                this.unRegistryBuild();
            }
        }
        finally {
            this.buildContainer.clear();
            if (this.buildType == 1) {
                AopUtils.recoverAop();
            }
            this.buildType = 0;
        }
    }

    private void registryBuild() throws Exception {
        this.pluginPostProcessor.registry(this.buildContainer);
        for (PluginRegistryInfo pluginRegistryInfo : this.buildContainer) {
            this.pluginListenerFactory.registry(pluginRegistryInfo.getPluginWrapper().getPluginId());
        }
    }

    private void unRegistryBuild() throws Exception {
        this.pluginPostProcessor.unRegistry(this.buildContainer);
        for (PluginRegistryInfo pluginRegistryInfo : this.buildContainer) {
            this.pluginListenerFactory.unRegistry(pluginRegistryInfo.getPluginWrapper().getPluginId());
        }
    }

    @Override
    public void addListener(PluginListener pluginListener) {
        this.pluginListenerFactory.addPluginListener(pluginListener);
    }

    @Override
    public <T extends PluginListener> void addListener(Class<T> pluginListenerClass) {
        this.pluginListenerFactory.addPluginListener(pluginListenerClass);
    }

    @Override
    public void addListener(List<PluginListener> pluginListeners) {
        if (pluginListeners != null) {
            for (PluginListener pluginListener : pluginListeners) {
                this.pluginListenerFactory.addPluginListener(pluginListener);
            }
        }
    }
}

