/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.gitee.starblues.extension.mybatis.SpringBootMybatisExtension;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.LanguageDriverRegistry;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class PluginFollowCoreConfig {
    private final ApplicationContext mainApplicationContext;

    public PluginFollowCoreConfig(ApplicationContext mainApplicationContext) {
        this.mainApplicationContext = mainApplicationContext;
    }

    public DataSource getDataSource() {
        return (DataSource)this.mainApplicationContext.getBean(DataSource.class);
    }

    public Configuration getConfiguration(SpringBootMybatisExtension.Type type) {
        Configuration configuration = new Configuration();
        if (type == SpringBootMybatisExtension.Type.MYBATIS) {
            try {
                Map customizerMap = this.mainApplicationContext.getBeansOfType(org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer.class);
                if (!customizerMap.isEmpty()) {
                    for (org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer customizer : customizerMap.values()) {
                        customizer.customize(configuration);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return configuration;
    }

    public MybatisConfiguration getMybatisPlusConfiguration() {
        MybatisConfiguration configuration = new MybatisConfiguration();
        try {
            Map customizerMap = this.mainApplicationContext.getBeansOfType(ConfigurationCustomizer.class);
            if (!customizerMap.isEmpty()) {
                for (ConfigurationCustomizer customizer : customizerMap.values()) {
                    customizer.customize(configuration);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configuration;
    }

    public Interceptor[] getInterceptor() {
        Map beanInterceptorMap;
        HashMap interceptorMap = new HashMap();
        try {
            SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.mainApplicationContext.getBean(SqlSessionFactory.class);
            List interceptors = sqlSessionFactory.getConfiguration().getInterceptors();
            if (interceptors != null) {
                for (Interceptor interceptor : interceptors) {
                    if (interceptor == null) continue;
                    interceptorMap.put(interceptor.getClass(), interceptor);
                }
            }
        }
        catch (Exception sqlSessionFactory) {
            // empty catch block
        }
        if (!(beanInterceptorMap = this.mainApplicationContext.getBeansOfType(Interceptor.class)).isEmpty()) {
            beanInterceptorMap.forEach((k, v) -> interceptorMap.put(v.getClass(), (Interceptor)v));
        }
        if (interceptorMap.isEmpty()) {
            return null;
        }
        return interceptorMap.values().toArray(new Interceptor[0]);
    }

    public DatabaseIdProvider getDatabaseIdProvider() {
        String[] beanNamesForType = this.mainApplicationContext.getBeanNamesForType(DatabaseIdProvider.class, false, false);
        if (beanNamesForType.length > 0) {
            return (DatabaseIdProvider)this.mainApplicationContext.getBean(DatabaseIdProvider.class);
        }
        return null;
    }

    public LanguageDriver[] getLanguageDriver() {
        HashMap languageDriverMap = new HashMap();
        try {
            SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.mainApplicationContext.getBean(SqlSessionFactory.class);
            LanguageDriverRegistry languageRegistry = sqlSessionFactory.getConfiguration().getLanguageRegistry();
            Field proxyTypesField = ReflectionUtils.findField(languageRegistry.getClass(), (String)"LANGUAGE_DRIVER_MAP");
            Map driverMap = null;
            if (proxyTypesField != null) {
                if (!proxyTypesField.isAccessible()) {
                    proxyTypesField.setAccessible(true);
                }
                driverMap = (Map)proxyTypesField.get(languageRegistry);
            }
            if (driverMap != null) {
                languageDriverMap.putAll(driverMap);
            }
        }
        catch (Exception sqlSessionFactory) {
            // empty catch block
        }
        Map beansLanguageDriver = this.mainApplicationContext.getBeansOfType(LanguageDriver.class);
        if (!beansLanguageDriver.isEmpty()) {
            beansLanguageDriver.forEach((k, v) -> languageDriverMap.put(v.getClass(), v));
        }
        if (languageDriverMap.isEmpty()) {
            return null;
        }
        return languageDriverMap.values().toArray(new LanguageDriver[0]);
    }
}

