/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.memcached;

import com.giffing.wicket.spring.boot.context.exceptions.WicketSpringBootException;
import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.context.extensions.types.DurationUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.SessionUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.TypeParser;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.memcached.DataStoreMemcachedProperties;
import java.io.IOException;
import net.spy.memcached.MemcachedClient;
import org.apache.wicket.Application;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.wicketstuff.datastores.common.SessionQuotaManagingDataStore;
import org.wicketstuff.datastores.memcached.IMemcachedSettings;
import org.wicketstuff.datastores.memcached.MemcachedDataStore;
import org.wicketstuff.datastores.memcached.MemcachedSettings;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.datastore.memcached", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={MemcachedClient.class, MemcachedDataStore.class})
@EnableConfigurationProperties(value={DataStoreMemcachedProperties.class})
public class DataStoreMemcachedConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private DataStoreMemcachedProperties prop;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        webApplication.setPageManagerProvider((IPageManagerProvider)new DefaultPageManagerProvider((Application)webApplication){

            protected IDataStore newDataStore() {
                MemcachedDataStore memcachedDataStore;
                MemcachedSettings settings = new MemcachedSettings();
                settings.setExpirationTime(DataStoreMemcachedConfig.this.prop.getExpirationTime());
                settings.setPort(DataStoreMemcachedConfig.this.prop.getPort());
                settings.setServerNames(DataStoreMemcachedConfig.this.prop.getServerNames());
                settings.setShutdownTimeout(TypeParser.parse((Long)DataStoreMemcachedConfig.this.prop.getShutdownTimeout(), (DurationUnit)DataStoreMemcachedConfig.this.prop.getShutdownTimeoutUnit()));
                try {
                    memcachedDataStore = new MemcachedDataStore((IMemcachedSettings)settings);
                }
                catch (IOException e) {
                    throw new WicketSpringBootException((Throwable)e);
                }
                return new SessionQuotaManagingDataStore((IDataStore)memcachedDataStore, TypeParser.parse((Long)DataStoreMemcachedConfig.this.prop.getSessionSize(), (SessionUnit)DataStoreMemcachedConfig.this.prop.getSessionUnit()));
            }
        });
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.prop).build());
    }
}

