/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.cassandra;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.context.extensions.types.DurationUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.SessionUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.TypeParser;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.cassandra.DataStoreCassandraProperties;
import org.apache.wicket.Application;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.wicketstuff.datastores.cassandra.CassandraDataStore;
import org.wicketstuff.datastores.cassandra.CassandraSettings;
import org.wicketstuff.datastores.cassandra.ICassandraSettings;
import org.wicketstuff.datastores.common.SessionQuotaManagingDataStore;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.datastore.cassandra", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(name={"com.datastax.driver.core.Session"}, value={CassandraDataStore.class})
@EnableConfigurationProperties(value={DataStoreCassandraProperties.class})
@AutoConfigureAfter(value={CassandraAutoConfiguration.class})
public class DataStoreCassandraConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private DataStoreCassandraProperties prop;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        CassandraSettings settings = new CassandraSettings();
        settings.getContactPoints().addAll(this.prop.getContactPoints());
        settings.setTableName(this.prop.getTableName());
        settings.setKeyspaceName(this.prop.getKeyspaceName());
        settings.setRecordTtl(TypeParser.parse((Long)this.prop.getRecordTtl(), (DurationUnit)this.prop.getRecordTtlUnit()));
        webApplication.setPageManagerProvider((IPageManagerProvider)new DefaultPageManagerProvider((Application)webApplication, (ICassandraSettings)settings){
            final /* synthetic */ ICassandraSettings val$settings;
            {
                this.val$settings = iCassandraSettings;
                super(x0);
            }

            protected IDataStore newDataStore() {
                return new SessionQuotaManagingDataStore((IDataStore)new CassandraDataStore(this.val$settings), TypeParser.parse((Long)DataStoreCassandraConfig.this.prop.getSessionSize(), (SessionUnit)DataStoreCassandraConfig.this.prop.getSessionUnit()));
            }
        });
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.prop).build());
    }
}

