/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.MaskWriteRegisterResponse;
import com.ghgande.j2mod.modbus.msg.ModbusMessageImpl;
import com.ghgande.j2mod.modbus.msg.ReadCoilsResponse;
import com.ghgande.j2mod.modbus.msg.ReadCommEventCounterResponse;
import com.ghgande.j2mod.modbus.msg.ReadCommEventLogResponse;
import com.ghgande.j2mod.modbus.msg.ReadExceptionStatusResponse;
import com.ghgande.j2mod.modbus.msg.ReadFIFOQueueResponse;
import com.ghgande.j2mod.modbus.msg.ReadFileRecordResponse;
import com.ghgande.j2mod.modbus.msg.ReadInputDiscretesResponse;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersResponse;
import com.ghgande.j2mod.modbus.msg.ReadMEIResponse;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.msg.ReadSerialDiagnosticsResponse;
import com.ghgande.j2mod.modbus.msg.ReadWriteMultipleResponse;
import com.ghgande.j2mod.modbus.msg.ReportSlaveIDResponse;
import com.ghgande.j2mod.modbus.msg.WriteCoilResponse;
import com.ghgande.j2mod.modbus.msg.WriteFileRecordResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleCoilsResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.msg.WriteSingleRegisterResponse;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModbusResponse
extends ModbusMessageImpl {
    private static final Logger logger = LoggerFactory.getLogger(ModbusResponse.class);
    private AuxiliaryMessageTypes auxiliaryType = AuxiliaryMessageTypes.NONE;

    public static ModbusResponse createModbusResponse(int functionCode) {
        ModbusResponse response;
        switch (functionCode) {
            case 1: {
                response = new ReadCoilsResponse();
                break;
            }
            case 2: {
                response = new ReadInputDiscretesResponse();
                break;
            }
            case 3: {
                response = new ReadMultipleRegistersResponse();
                break;
            }
            case 4: {
                response = new ReadInputRegistersResponse();
                break;
            }
            case 5: {
                response = new WriteCoilResponse();
                break;
            }
            case 6: {
                response = new WriteSingleRegisterResponse();
                break;
            }
            case 15: {
                response = new WriteMultipleCoilsResponse();
                break;
            }
            case 16: {
                response = new WriteMultipleRegistersResponse();
                break;
            }
            case 7: {
                response = new ReadExceptionStatusResponse();
                break;
            }
            case 8: {
                response = new ReadSerialDiagnosticsResponse();
                break;
            }
            case 11: {
                response = new ReadCommEventCounterResponse();
                break;
            }
            case 12: {
                response = new ReadCommEventLogResponse();
                break;
            }
            case 17: {
                response = new ReportSlaveIDResponse();
                break;
            }
            case 20: {
                response = new ReadFileRecordResponse();
                break;
            }
            case 21: {
                response = new WriteFileRecordResponse();
                break;
            }
            case 22: {
                response = new MaskWriteRegisterResponse();
                break;
            }
            case 23: {
                response = new ReadWriteMultipleResponse();
                break;
            }
            case 24: {
                response = new ReadFIFOQueueResponse();
                break;
            }
            case 43: {
                response = new ReadMEIResponse();
                break;
            }
            default: {
                response = (functionCode & 0x80) != 0 ? new ExceptionResponse(functionCode) : new ExceptionResponse();
            }
        }
        return response;
    }

    protected void setMessage(byte[] msg) {
        try {
            this.readData(new DataInputStream(new ByteArrayInputStream(msg)));
        }
        catch (IOException ex) {
            logger.error("Problem setting response message - {}", (Object)ex.getMessage());
        }
    }

    public AuxiliaryMessageTypes getAuxiliaryType() {
        return this.auxiliaryType;
    }

    public void setAuxiliaryType(AuxiliaryMessageTypes auxiliaryType) {
        this.auxiliaryType = auxiliaryType;
    }

    public static enum AuxiliaryMessageTypes {
        NONE,
        UNIT_ID_MISSMATCH;

    }
}

