/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.api.util;

import com.geely.gbop.api.GbopApiApp;
import com.geely.gbop.api.GbopApiException;
import com.geely.gbop.api.GbopApiRequest;
import com.geely.gbop.api.contant.HttpContentType;
import com.geely.gbop.api.contant.HttpMethod;
import com.geely.gbop.api.sign.SignerManager;
import com.geely.gbop.api.util.JsonUtils;
import com.geely.gbop.api.util.SdkVersionUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;

public class GbopHttpBuild {
    public static final String GBOP_SDK_VERSION = SdkVersionUtil.getVersion() == null ? "1.0-SNAPSHOT" : SdkVersionUtil.getVersion();

    public static Request buildRequest(GbopApiRequest apiItem, GbopApiApp app, String serverHost) {
        if (apiItem.getMethod() == null) {
            throw new GbopApiException("\u8bf7\u8bbe\u7f6eapiItem\u7684method");
        }
        if (apiItem.getContentType() == null && apiItem.getMethod() != HttpMethod.GET && apiItem.getMethod() != HttpMethod.HEAD) {
            throw new GbopApiException("\u8bf7\u8bbe\u7f6eapiItem\u7684contentType");
        }
        RequestBody body = apiItem.getBody();
        apiItem.addHead("X-Gapi-Sdk-Language", "java");
        apiItem.addHead("X-Gapi-Sdk-Version", GBOP_SDK_VERSION);
        try {
            if (body != null && body.contentLength() > 0L) {
                apiItem.addHead("Content-Length", body.contentLength() + "");
                apiItem.addCustomSignHead("Content-Length");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new GbopApiException(e.getMessage());
        }
        SignerManager.lookup(apiItem.getSignMehod()).sign(app, serverHost, apiItem.getMethod(), apiItem);
        String url = GbopHttpBuild.buildUrl(serverHost, apiItem.getPath(), apiItem.getParams());
        Headers headers = GbopHttpBuild.buildHeader(apiItem);
        Request.Builder builder = new Request.Builder();
        Request request = null;
        if (apiItem.getMethod() == HttpMethod.GET) {
            request = builder.url(url).headers(headers).get().build();
        } else if (apiItem.getMethod() == HttpMethod.HEAD) {
            request = builder.url(url).headers(headers).head().build();
        } else if (apiItem.getMethod() == HttpMethod.POST) {
            request = builder.url(url).headers(headers).post(body).build();
        } else if (apiItem.getMethod() == HttpMethod.PUT) {
            request = builder.url(url).headers(headers).put(body).build();
        } else if (apiItem.getMethod() == HttpMethod.DELETE) {
            request = builder.url(url).headers(headers).delete(body).build();
        } else if (apiItem.getMethod() == HttpMethod.PATCH) {
            request = builder.url(url).headers(headers).patch(body).build();
        }
        return request;
    }

    public static String buildUrl(String host, String path, Map<String, Object> queries) {
        StringBuilder sbUrl = new StringBuilder(host);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            sbUrl.append(path);
        }
        TreeMap<String, Object> sortMap = new TreeMap<String, Object>();
        if (null != queries) {
            for (Map.Entry<String, Object> query : queries.entrySet()) {
                if (StringUtils.isBlank((CharSequence)query.getKey())) continue;
                sortMap.put(query.getKey(), query.getValue());
            }
        }
        if (null != sortMap && sortMap.keySet().size() > 0) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry query : sortMap.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)query.getKey()))) continue;
                if (query.getValue() == null) {
                    sbQuery.append((String)query.getKey()).append("=");
                    continue;
                }
                if (query.getValue() instanceof List) {
                    List valueStrs = ((List)query.getValue()).stream().map(e -> e.toString()).collect(Collectors.toList());
                    Collections.sort(valueStrs);
                    for (int i = 0; i < valueStrs.size(); ++i) {
                        try {
                            sbQuery.append((String)query.getKey()).append("=").append(URLEncoder.encode((String)valueStrs.get(i), "utf-8"));
                        }
                        catch (UnsupportedEncodingException e2) {
                            e2.printStackTrace();
                        }
                        if (i >= valueStrs.size() - 1) continue;
                        sbQuery.append("&");
                    }
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)query.getValue().toString())) {
                    try {
                        sbQuery.append((String)query.getKey()).append("=").append(URLEncoder.encode(query.getValue().toString(), "utf-8"));
                    }
                    catch (UnsupportedEncodingException e3) {
                        e3.printStackTrace();
                    }
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)query.getValue().toString())) continue;
                sbQuery.append((String)query.getKey()).append("=");
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    public static Headers buildHeader(GbopApiRequest apiItem) {
        Headers.Builder mHeaderBuild = new Headers.Builder();
        if (apiItem.getHeaders() != null && apiItem.getHeaders().keySet().size() > 0) {
            for (Map.Entry<String, String> head : apiItem.getHeaders().entrySet()) {
                mHeaderBuild.add(head.getKey(), head.getValue());
            }
        }
        return mHeaderBuild.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestBody buildRequestBody(HttpContentType contentType, Object body) {
        RequestBody requestBody = null;
        if (contentType == HttpContentType.JSON) {
            return RequestBody.create((String)JsonUtils.writeValueAsString(body), (MediaType)MediaType.parse((String)HttpContentType.JSON.getValue()));
        }
        if (contentType == HttpContentType.SIGLE_OCSTREAM) {
            if (body instanceof File) {
                return RequestBody.create((MediaType)MediaType.parse((String)HttpContentType.SIGLE_OCSTREAM.getValue()), (File)((File)body));
            }
            if (!(body instanceof String)) throw new GbopApiException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u6d41\u53c2\u6570");
            return RequestBody.create((MediaType)MediaType.parse((String)HttpContentType.SIGLE_OCSTREAM.getValue()), (File)new File(body.toString()));
        }
        if (contentType != HttpContentType.XML) throw new GbopApiException("\u6682\u65f6\u4e0d\u652f\u6301\u7684RequestBody\u7c7b\u578b\uff0c\u8bf7\u81ea\u884c\u6269\u5c55\u6784\u5efaRequestBody");
        return RequestBody.create((String)body.toString(), (MediaType)MediaType.parse((String)HttpContentType.XML.getValue()));
    }

    public RequestBody extendBuildRequestBody(HttpContentType contentType, Object body) {
        File file = new File("/sss");
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("name", "zhangsan").addFormDataPart("age", "20").addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).build();
        return requestBody;
    }
}

