/*
 * Decompiled with CFR 0.152.
 */
package com.fulmicoton.multiregexp;

import com.fulmicoton.multiregexp.MultiPattern;
import com.fulmicoton.multiregexp.MultiPatternAutomaton;
import com.fulmicoton.multiregexp.Scanner;
import com.fulmicoton.multiregexp.Token;
import java.util.ArrayList;
import java.util.Iterator;

public class Lexer<T extends Enum> {
    private final ArrayList<T> types = new ArrayList();
    private final ArrayList<String> patterns = new ArrayList();
    private transient MultiPatternAutomaton automaton = null;

    public Lexer<T> addRule(T tokenType, String pattern) {
        this.types.add(tokenType);
        this.patterns.add(pattern);
        this.automaton = null;
        return this;
    }

    public MultiPatternAutomaton getAutomaton() {
        if (this.automaton == null) {
            this.automaton = MultiPattern.of(this.patterns).makeAutomatonWithPrefix("");
        }
        return this.automaton;
    }

    public Scanner<T> scannerFor(CharSequence seq) {
        return new Scanner<T>(this.getAutomaton(), seq, this.types);
    }

    public Iterable<Token<T>> scan(CharSequence seq) {
        final Scanner<T> scanner = this.scannerFor(seq);
        scanner.nextUnchecked();
        return new Iterable<Token<T>>(){
            Token<T> next;
            {
                this.next = Token.fromScanner(scanner);
            }

            @Override
            public Iterator<Token<T>> iterator() {
                return new Iterator<Token<T>>(){

                    @Override
                    public boolean hasNext() {
                        return next != null;
                    }

                    @Override
                    public Token<T> next() {
                        Token buff = next;
                        next = scanner.nextUnchecked() ? Token.fromScanner(scanner) : null;
                        return buff;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

