/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.content.Context;
import android.util.Log;
import androidx.annotation.GuardedBy;
import com.frybits.harmony.secure.HarmonyKeysetReader;
import com.frybits.harmony.secure.HarmonyKeysetWriter;
import com.frybits.harmony.secure._InternalCoreHarmony;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetManager;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.integration.android.AndroidKeystoreKmsClient;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.ProviderException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0002\u000b\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/crypto/tink/integration/android/HarmonyKeysetManager;", "", "builder", "Lcom/google/crypto/tink/integration/android/HarmonyKeysetManager$Builder;", "(Lcom/google/crypto/tink/integration/android/HarmonyKeysetManager$Builder;)V", "keysetHandle", "Lcom/google/crypto/tink/KeysetHandle;", "getKeysetHandle", "()Lcom/google/crypto/tink/KeysetHandle;", "keysetManager", "Lcom/google/crypto/tink/KeysetManager;", "Builder", "Companion", "crypto_release"})
public final class HarmonyKeysetManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @GuardedBy(value="this")
    @NotNull
    private KeysetManager keysetManager;
    private static final String TAG = HarmonyKeysetManager.class.getSimpleName();

    private HarmonyKeysetManager(Builder builder) {
        this.keysetManager = builder.getKeysetManager();
    }

    @NotNull
    public final synchronized KeysetHandle getKeysetHandle() {
        KeysetHandle keysetHandle = this.keysetManager.getKeysetHandle();
        Intrinsics.checkNotNullExpressionValue((Object)keysetHandle, (String)"getKeysetHandle(...)");
        return keysetHandle;
    }

    public /* synthetic */ HarmonyKeysetManager(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020\bH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\u000eH\u0002J\u001e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\u0010\u0010&\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0018@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lcom/google/crypto/tink/integration/android/HarmonyKeysetManager$Builder;", "", "()V", "keyStore", "Ljava/security/KeyStore;", "keyTemplate", "Lcom/google/crypto/tink/KeyTemplate;", "keysetManager", "Lcom/google/crypto/tink/KeysetManager;", "getKeysetManager", "()Lcom/google/crypto/tink/KeysetManager;", "setKeysetManager", "(Lcom/google/crypto/tink/KeysetManager;)V", "<set-?>", "Lcom/google/crypto/tink/Aead;", "masterKey", "getMasterKey", "()Lcom/google/crypto/tink/Aead;", "masterKeyUri", "", "reader", "Lcom/google/crypto/tink/KeysetReader;", "useKeystore", "", "Lcom/google/crypto/tink/KeysetWriter;", "writer", "getWriter", "()Lcom/google/crypto/tink/KeysetWriter;", "build", "Lcom/google/crypto/tink/integration/android/HarmonyKeysetManager;", "read", "readOrGenerateNewKeyset", "readOrGenerateNewMasterKey", "withHarmony", "context", "Landroid/content/Context;", "type", "prefFileName", "withKeyTemplate", "withMasterKeyUri", "crypto_release"})
    @SourceDebugExtension(value={"SMAP\nHarmonyKeysetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HarmonyKeysetManager.kt\ncom/google/crypto/tink/integration/android/HarmonyKeysetManager$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
    public static final class Builder {
        private KeysetReader reader;
        private KeysetWriter writer;
        @Nullable
        private String masterKeyUri;
        @Nullable
        private Aead masterKey;
        private boolean useKeystore = true;
        @Nullable
        private KeyTemplate keyTemplate;
        @Nullable
        private KeyStore keyStore;
        @GuardedBy(value="this")
        public KeysetManager keysetManager;

        @NotNull
        public final KeysetWriter getWriter() {
            KeysetWriter keysetWriter = this.writer;
            if (keysetWriter != null) {
                return keysetWriter;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            return null;
        }

        @Nullable
        public final Aead getMasterKey() {
            return this.masterKey;
        }

        @NotNull
        public final KeysetManager getKeysetManager() {
            KeysetManager keysetManager = this.keysetManager;
            if (keysetManager != null) {
                return keysetManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"keysetManager");
            return null;
        }

        public final void setKeysetManager(@NotNull KeysetManager keysetManager) {
            Intrinsics.checkNotNullParameter((Object)keysetManager, (String)"<set-?>");
            this.keysetManager = keysetManager;
        }

        @NotNull
        public final Builder withHarmony(@NotNull Context context, @NotNull String type, @NotNull String prefFileName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)prefFileName, (String)"prefFileName");
            File keysetFile = _InternalCoreHarmony.keysetFile(context, prefFileName, type);
            File keysetFileLock = _InternalCoreHarmony.keysetFileLock(context, prefFileName, type);
            this.reader = new HarmonyKeysetReader(keysetFile, keysetFileLock);
            this.writer = new HarmonyKeysetWriter(keysetFile, keysetFileLock);
            return this;
        }

        @NotNull
        public final Builder withMasterKeyUri(@NotNull String masterKeyUri) {
            Intrinsics.checkNotNullParameter((Object)masterKeyUri, (String)"masterKeyUri");
            if (!StringsKt.startsWith$default((String)masterKeyUri, (String)"android-keystore://", (boolean)false, (int)2, null)) {
                boolean $i$a$-require-HarmonyKeysetManager$Builder$withMasterKeyUri$32 = false;
                String $i$a$-require-HarmonyKeysetManager$Builder$withMasterKeyUri$32 = "key URI must start with android-keystore://";
                throw new IllegalArgumentException($i$a$-require-HarmonyKeysetManager$Builder$withMasterKeyUri$32.toString());
            }
            if (!this.useKeystore) {
                boolean bl = false;
                String string = "cannot call withMasterKeyUri() after calling doNotUseKeystore()";
                throw new IllegalArgumentException(string.toString());
            }
            this.masterKeyUri = masterKeyUri;
            return this;
        }

        @NotNull
        public final Builder withKeyTemplate(@Nullable KeyTemplate keyTemplate) {
            this.keyTemplate = keyTemplate;
            return this;
        }

        @NotNull
        public final synchronized HarmonyKeysetManager build() {
            if (this.masterKeyUri != null) {
                this.masterKey = this.readOrGenerateNewMasterKey();
            }
            this.setKeysetManager(this.readOrGenerateNewKeyset());
            return new HarmonyKeysetManager(this, null);
        }

        private final Aead readOrGenerateNewMasterKey() {
            AndroidKeystoreKmsClient androidKeystoreKmsClient;
            if (this.keyStore != null) {
                AndroidKeystoreKmsClient androidKeystoreKmsClient2 = new AndroidKeystoreKmsClient.Builder().setKeyStore(this.keyStore).build();
                Intrinsics.checkNotNull((Object)androidKeystoreKmsClient2);
                androidKeystoreKmsClient = androidKeystoreKmsClient2;
            } else {
                androidKeystoreKmsClient = new AndroidKeystoreKmsClient();
            }
            AndroidKeystoreKmsClient client = androidKeystoreKmsClient;
            boolean existed = client.hasKey(this.masterKeyUri);
            if (!existed) {
                try {
                    AndroidKeystoreKmsClient.generateNewAeadKey((String)this.masterKeyUri);
                }
                catch (GeneralSecurityException ex) {
                    Log.w((String)TAG, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)ex);
                    return null;
                }
                catch (ProviderException ex) {
                    Log.w((String)TAG, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)ex);
                    return null;
                }
            }
            try {
                return client.getAead(this.masterKeyUri);
            }
            catch (GeneralSecurityException ex) {
                if (existed) {
                    throw new KeyStoreException("the master key " + this.masterKeyUri + " exists but is unusable", ex);
                }
                Log.w((String)TAG, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)ex);
            }
            catch (ProviderException ex) {
                if (existed) {
                    throw new KeyStoreException("the master key " + this.masterKeyUri + " exists but is unusable", ex);
                }
                Log.w((String)TAG, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)ex);
            }
            return null;
        }

        private final KeysetManager readOrGenerateNewKeyset() {
            try {
                return this.read();
            }
            catch (FileNotFoundException ex) {
                Log.i((String)TAG, (String)("keyset not found, will generate a new one. " + ex.getMessage()));
                if (this.keyTemplate != null) {
                    KeysetManager manager = KeysetManager.withEmptyKeyset().add(this.keyTemplate);
                    int keyId = manager.getKeysetHandle().getKeysetInfo().getKeyInfo(0).getKeyId();
                    manager = manager.setPrimary(keyId);
                    if (this.masterKey != null) {
                        manager.getKeysetHandle().write(this.getWriter(), this.masterKey);
                    } else {
                        CleartextKeysetHandle.write((KeysetHandle)manager.getKeysetHandle(), (KeysetWriter)this.getWriter());
                    }
                    KeysetManager keysetManager = manager;
                    Intrinsics.checkNotNull((Object)keysetManager);
                    return keysetManager;
                }
                throw new GeneralSecurityException("cannot read or generate keyset");
            }
        }

        private final KeysetManager read() {
            KeysetReader keysetReader;
            if (this.masterKey != null) {
                try {
                    KeysetReader keysetReader2 = this.reader;
                    if (keysetReader2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"reader");
                        keysetReader2 = null;
                    }
                    KeysetManager keysetManager = KeysetManager.withKeysetHandle((KeysetHandle)KeysetHandle.read((KeysetReader)keysetReader2, (Aead)this.masterKey));
                    Intrinsics.checkNotNullExpressionValue((Object)keysetManager, (String)"withKeysetHandle(...)");
                    return keysetManager;
                }
                catch (InvalidProtocolBufferException ex) {
                    Log.w((String)TAG, (String)"cannot decrypt keyset: ", (Throwable)ex);
                }
                catch (GeneralSecurityException ex) {
                    Log.w((String)TAG, (String)"cannot decrypt keyset: ", (Throwable)ex);
                }
            }
            if ((keysetReader = this.reader) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"reader");
                keysetReader = null;
            }
            KeysetManager keysetManager = KeysetManager.withKeysetHandle((KeysetHandle)CleartextKeysetHandle.read((KeysetReader)keysetReader));
            Intrinsics.checkNotNullExpressionValue((Object)keysetManager, (String)"withKeysetHandle(...)");
            return keysetManager;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/google/crypto/tink/integration/android/HarmonyKeysetManager$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "crypto_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

