/*
 * Decompiled with CFR 0.152.
 */
package com.fredhopper.lifecycle;

import com.fredhopper.lifecycle.AbstractLifeCycle;
import com.fredhopper.lifecycle.LifeCycle;
import com.fredhopper.lifecycle.State;

public class Container
extends AbstractLifeCycle {
    private final LifeCycle lifeCycle;
    private final boolean separateThreads;
    private final Thread bootstrapThread;
    private final Thread shutdownstrapThread;

    public Container(LifeCycle lifeCycle) {
        this(lifeCycle, true, true);
    }

    public Container(LifeCycle lifeCycle, boolean separateThreads, boolean shutdownHook) {
        this.lifeCycle = lifeCycle;
        this.separateThreads = separateThreads;
        if (separateThreads) {
            this.bootstrapThread = new Thread((Runnable)new Bootstrap(), "bootstrap-" + this.toString(lifeCycle));
            this.shutdownstrapThread = new Thread((Runnable)new Shutdownstrap(), "shutdownstrap-" + this.toString(lifeCycle));
        } else {
            this.bootstrapThread = null;
            this.shutdownstrapThread = null;
        }
        if (shutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new Shutdownstrap(), "jvm-shutdown-" + this.toString(lifeCycle)));
        }
    }

    @Override
    public State getState() {
        return this.lifeCycle.getState();
    }

    @Override
    protected void doInitLifeCycle() throws Exception {
        this.lifeCycle.initLifeCycle();
    }

    @Override
    protected void doStartLifeCycle() throws Exception {
        if (this.separateThreads) {
            this.bootstrapThread.start();
        } else {
            this.lifeCycle.startLifeCycle();
        }
        this.awaitState(State.RUNNING);
    }

    @Override
    protected void doPause() throws Exception {
        this.lifeCycle.pause();
    }

    @Override
    protected void doResume() throws Exception {
        this.lifeCycle.resume();
    }

    @Override
    protected void doStopLifeCycle() throws Exception {
        if (this.separateThreads) {
            this.shutdownstrapThread.start();
        } else {
            this.lifeCycle.stopLifeCycle();
        }
        this.awaitState(State.STOPPED);
    }

    @Override
    public String toString() {
        return "Container[" + this.toString(this.lifeCycle) + "]";
    }

    private void awaitState(State expectedState) throws Exception {
        while (this.lifeCycle.getState() != expectedState) {
            Thread.sleep(1L);
        }
    }

    private String toString(LifeCycle lc) {
        return lc.getClass().getSimpleName() + "@" + Integer.toHexString(lc.hashCode());
    }

    private class Shutdownstrap
    implements Runnable {
        private Shutdownstrap() {
        }

        @Override
        public void run() {
            if (Container.this.getState() != State.RUNNING) {
                return;
            }
            try {
                Container.this.lifeCycle.stopLifeCycle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class Bootstrap
    implements Runnable {
        private Bootstrap() {
        }

        @Override
        public void run() {
            if (Container.this.getState() != State.INITIALIZED) {
                return;
            }
            try {
                Container.this.lifeCycle.startLifeCycle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

