/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen.metadata;

import com.sforce.ws.codegen.metadata.ClassMetadata;
import com.sforce.ws.codegen.metadata.MemberMetadata;
import java.util.List;

public class ComplexClassMetadata
extends ClassMetadata {
    private final String xsiType;
    private final String superWrite;
    private final String superLoad;
    private final String superToString;
    private final List<MemberMetadata> memberMetadataList;
    private final boolean generateInterfaces;
    private final String typeExtension;
    private final String baseComplexClass;

    public ComplexClassMetadata(String packageName, String className, String typeExtension, String xsiType, String superWrite, String superLoad, String superToString, List<MemberMetadata> memberMetadataList, boolean generateInterfaces, String interfacePackageName, String baseComplexClass) {
        super(packageName, className, interfacePackageName);
        this.typeExtension = typeExtension;
        this.xsiType = xsiType;
        this.superWrite = superWrite;
        this.superLoad = superLoad;
        this.superToString = superToString;
        this.memberMetadataList = memberMetadataList;
        this.generateInterfaces = generateInterfaces;
        this.baseComplexClass = baseComplexClass;
    }

    public String getXsiType() {
        return this.xsiType;
    }

    public String getSuperWrite() {
        return this.superWrite;
    }

    public String getSuperLoad() {
        return this.superLoad;
    }

    public String getSuperToString() {
        return this.superToString;
    }

    public String getTypeExtension() {
        return this.typeExtension;
    }

    public List<MemberMetadata> getMemberMetadataList() {
        return this.memberMetadataList;
    }

    public boolean getGenerateInterfaces() {
        return this.generateInterfaces;
    }

    public String getInterfaceExtension() {
        if (!this.generateInterfaces) {
            return "";
        }
        String typeExt = this.getTypeExtension().toLowerCase();
        if (typeExt.contains("implements")) {
            return ", " + this.getInterfaceName();
        }
        return "implements " + this.getInterfaceName();
    }

    public boolean getHasBaseComplexClass() {
        return this.baseComplexClass != null;
    }

    public String getBaseComplexClass() {
        return this.baseComplexClass;
    }

    public String getBaseComplexClassInterface() {
        if (this.baseComplexClass == null) {
            return null;
        }
        int position = this.baseComplexClass.lastIndexOf(".");
        return this.baseComplexClass.substring(0, position + 1) + "I" + this.baseComplexClass.substring(position + 1);
    }

    public boolean getHasArrayField() {
        for (MemberMetadata m : this.memberMetadataList) {
            if (!m.getIsArray()) continue;
            return true;
        }
        return false;
    }
}

