/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flybits.internal.db.CachingEntryDAO;
import com.flybits.internal.db.models.CachingEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class CachingEntryDAO_Impl
implements CachingEntryDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CachingEntry> __insertionAdapterOfCachingEntry;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllByCachingKey;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByCachingKeyAndValue;

    public CachingEntryDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCachingEntry = new EntityInsertionAdapter<CachingEntry>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `cachingentry` (`cachingkey`,`contentID`,`sequence`) VALUES (?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, CachingEntry value) {
                if (value.getCachingKey() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCachingKey());
                }
                if (value.getContentId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getContentId());
                }
                stmt.bindLong(3, (long)value.getSequence());
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from cachingentry";
                return "Delete from cachingentry";
            }
        };
        this.__preparedStmtOfDeleteAllByCachingKey = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from cachingentry WHERE cachingkey = ?";
                return "Delete from cachingentry WHERE cachingkey = ?";
            }
        };
        this.__preparedStmtOfDeleteByCachingKeyAndValue = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from cachingentry WHERE cachingkey = ? AND contentID = ?";
                return "Delete from cachingentry WHERE cachingkey = ? AND contentID = ?";
            }
        };
    }

    @Override
    public void insert(CachingEntry entry) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCachingEntry.insert((Object)entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<CachingEntry> entry) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCachingEntry.insert(entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllByCachingKey(String key) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllByCachingKey.acquire();
        int _argIndex = 1;
        if (key == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, key);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllByCachingKey.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByCachingKeyAndValue(String key, String value) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByCachingKeyAndValue.acquire();
        int _argIndex = 1;
        if (key == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, key);
        }
        _argIndex = 2;
        if (value == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, value);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByCachingKeyAndValue.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getIdsByCachingKey(String key) {
        String _sql = "SELECT contentID FROM cachingentry WHERE cachingkey = ? order by sequence ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT contentID FROM cachingentry WHERE cachingkey = ? order by sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUniqueIdsByCachingKey(String key) {
        String _sql = "SELECT contentId FROM ( SELECT contentID, sequence, cachingkey FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = ? ORDER BY sequence ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT contentId FROM ( SELECT contentID, sequence, cachingkey FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = ? ORDER BY sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CachingEntry> getByKey(String key) {
        String _sql = "SELECT * FROM cachingentry WHERE cachingkey = ? order by sequence ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM cachingentry WHERE cachingkey = ? order by sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCachingKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cachingkey");
            int _cursorIndexOfContentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentID");
            int _cursorIndexOfSequence = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sequence");
            ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CachingEntry _item = new CachingEntry();
                String _tmpCachingKey = _cursor.isNull(_cursorIndexOfCachingKey) ? null : _cursor.getString(_cursorIndexOfCachingKey);
                _item.setCachingKey(_tmpCachingKey);
                String _tmpContentId = _cursor.isNull(_cursorIndexOfContentId) ? null : _cursor.getString(_cursorIndexOfContentId);
                _item.setContentId(_tmpContentId);
                int _tmpSequence = _cursor.getInt(_cursorIndexOfSequence);
                _item.setSequence(_tmpSequence);
                _result.add(_item);
            }
            ArrayList<CachingEntry> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CachingEntry> getUniqueByKey(String key) {
        String _sql = "SELECT * FROM ( SELECT * FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = ? ORDER BY sequence ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ( SELECT * FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = ? ORDER BY sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCachingKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cachingkey");
            int _cursorIndexOfContentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentID");
            int _cursorIndexOfSequence = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sequence");
            ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CachingEntry _item = new CachingEntry();
                String _tmpCachingKey = _cursor.isNull(_cursorIndexOfCachingKey) ? null : _cursor.getString(_cursorIndexOfCachingKey);
                _item.setCachingKey(_tmpCachingKey);
                String _tmpContentId = _cursor.isNull(_cursorIndexOfContentId) ? null : _cursor.getString(_cursorIndexOfContentId);
                _item.setContentId(_tmpContentId);
                int _tmpSequence = _cursor.getInt(_cursorIndexOfSequence);
                _item.setSequence(_tmpSequence);
                _result.add(_item);
            }
            ArrayList<CachingEntry> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<CachingEntry>> getLive(String key) {
        String _sql = "SELECT * FROM cachingentry WHERE cachingkey = ? order by sequence ASC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM cachingentry WHERE cachingkey = ? order by sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"cachingentry"}, false, (Callable)new Callable<List<CachingEntry>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CachingEntry> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CachingEntryDAO_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCachingKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cachingkey");
                    int _cursorIndexOfContentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentID");
                    int _cursorIndexOfSequence = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sequence");
                    ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CachingEntry _item = new CachingEntry();
                        String _tmpCachingKey = _cursor.isNull(_cursorIndexOfCachingKey) ? null : _cursor.getString(_cursorIndexOfCachingKey);
                        _item.setCachingKey(_tmpCachingKey);
                        String _tmpContentId = _cursor.isNull(_cursorIndexOfContentId) ? null : _cursor.getString(_cursorIndexOfContentId);
                        _item.setContentId(_tmpContentId);
                        int _tmpSequence = _cursor.getInt(_cursorIndexOfSequence);
                        _item.setSequence(_tmpSequence);
                        _result.add(_item);
                    }
                    ArrayList<CachingEntry> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

