/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.deserializations;

import androidx.annotation.Nullable;
import com.flybits.commons.library.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class IDeserializer<T> {
    public static final String KEY_LIST_ITEM = "data";
    public static final String KEY_PAGING = "pagination";

    public abstract String toJson(T var1);

    @Nullable
    public T fromJson(String json) {
        try {
            Object jsonObject = new JSONTokener(json).nextValue();
            if (jsonObject instanceof JSONObject) {
                JSONObject jObject = new JSONObject(json);
                return this.fromJson(jObject);
            }
            if (jsonObject instanceof JSONArray) {
                JSONArray jObject = new JSONArray(json);
                return this.fromJson(jObject);
            }
        }
        catch (NullPointerException | JSONException e) {
            Logger.appendTag("Network").e("Exception encountered:", (Exception)e);
        }
        return null;
    }

    public abstract T fromJson(JSONObject var1);

    public abstract T fromJson(JSONArray var1);
}

