/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import com.flybits.commons.library.SecuredSharedElements;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.encryption.EncryptionManager;
import com.flybits.commons.library.encryption.SecuredPreferenceStore;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.utils.Utilities;
import com.flybits.internal.db.UserDAO;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/flybits/commons/library/SecuredSharedElements;", "Lcom/flybits/commons/library/SharedElements;", "sharedPreference", "Landroid/content/SharedPreferences;", "userDAO", "Lcom/flybits/internal/db/UserDAO;", "(Landroid/content/SharedPreferences;Lcom/flybits/internal/db/UserDAO;)V", "decodeEncryptedText", "Lcom/flybits/commons/library/encryption/EncryptionManager$EncryptedData;", "text", "", "decrypt", "encryptionManager", "Lcom/flybits/commons/library/encryption/EncryptionManager;", "migrateV2", "", "oldPreferences", "migrateV2$commons_release", "migrateV3", "context", "Landroid/content/Context;", "migrateV3$commons_release", "performMigration", "setBooleanVariable", "", "key", "value", "", "setStringVariable", "commons_release"})
public final class SecuredSharedElements
extends SharedElements {
    @NotNull
    private final SharedPreferences sharedPreference;

    public SecuredSharedElements(@NotNull SharedPreferences sharedPreference, @NotNull UserDAO userDAO) {
        Intrinsics.checkNotNullParameter((Object)sharedPreference, (String)"sharedPreference");
        Intrinsics.checkNotNullParameter((Object)userDAO, (String)"userDAO");
        super(sharedPreference, userDAO, null, 4, null);
        this.sharedPreference = sharedPreference;
    }

    @Override
    protected int performMigration(@NotNull Context context) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Ref.IntRef migratedValues = new Ref.IntRef();
        SharedPreferences it = context.getSharedPreferences("flybits_secure_storage_v2", 0);
        boolean bl = false;
        Map map = it.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.all");
        if (!map.isEmpty()) {
            BuildersKt.launch$default((CoroutineScope)this.getJob$commons_release(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(migratedValues, this, context, null){
                int label;
                final /* synthetic */ Ref.IntRef $migratedValues;
                final /* synthetic */ SecuredSharedElements this$0;
                final /* synthetic */ Context $context;
                {
                    this.$migratedValues = $migratedValues;
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.$migratedValues.element += this.this$0.migrateV3$commons_release(this.$context);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return migratedValues.element;
    }

    public final int migrateV3$commons_release(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String notificationChannelIdHashedKey;
            String notificationChannelIdValue;
            String idpConnectedHashedKey;
            String idpConnectedValue;
            String gatewayURLHashedKey;
            String gatewayURLValue;
            String uniqueIdHashedKey;
            String uniqueIdIdValue;
            String isTokenHashedKey;
            String isTokenIdValue;
            SharedPreferences oldPreferences = context.getSharedPreferences("flybits_secure_storage_v2", 0);
            Intrinsics.checkNotNullExpressionValue((Object)oldPreferences, (String)"oldPreferences");
            EncryptionManager encryptionManager2 = new EncryptionManager(context, oldPreferences, "flybits_secure_storage_v2", null, new SecuredPreferenceStore.KeyStoreRecoveryNotifier(){

                public boolean onRecoveryRequired(@NotNull Exception e, @Nullable KeyStore keyStore, @Nullable List<String> keyAliases) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    return true;
                }
            });
            int migratedCount = 0;
            String jwtHashedKey = EncryptionManager.Companion.getHashed("com.flybits.jwt.token");
            String jwtValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(jwtHashedKey, ""));
            if (jwtValue != null) {
                SharedElementsFactory.INSTANCE.get(context).setJWTToken(jwtValue);
                ++migratedCount;
            }
            String languageHashedKey = EncryptionManager.Companion.getHashed("com.flybits.language.codes");
            String languageValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(languageHashedKey, "en"));
            ArrayList<String> languages = Utilities.convertLocalizationStringToList(languageValue);
            SharedElementsFactory.INSTANCE.get(context).setLocalization(languages);
            ++migratedCount;
            String userHashedKey = EncryptionManager.Companion.getHashed("com.flybits.user");
            String userValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(userHashedKey, ""));
            User userObj = (User)new Gson().fromJson(userValue, User.class);
            SharedElementsFactory.INSTANCE.get(context).setUser(userObj);
            ++migratedCount;
            String locationHashedKey = EncryptionManager.Companion.getHashed("com.flybits.location.permission");
            String locationValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(locationHashedKey, ""));
            if (locationValue != null) {
                SharedElementsFactory.INSTANCE.get(context).setLocationPermission(locationValue);
                ++migratedCount;
            }
            String isNotificationHashedKey = EncryptionManager.Companion.getHashed("com.flybits.idp.isPushNotificationEnabled");
            boolean isNotificationValue = Boolean.parseBoolean(encryptionManager2.decrypt$commons_release(oldPreferences.getString(isNotificationHashedKey, "false")));
            SharedElementsFactory.INSTANCE.get(context).setIsPushEnabled(isNotificationValue);
            ++migratedCount;
            String userIdHashedKey = EncryptionManager.Companion.getHashed("com.flybits.user.id");
            String userIdValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(userIdHashedKey, ""));
            if (userIdValue != null) {
                SharedElementsFactory.INSTANCE.get(context).setUserId(userIdValue);
                ++migratedCount;
            }
            if ((isTokenIdValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(isTokenHashedKey = EncryptionManager.Companion.getHashed("com.flybits.push.isTokenSent"), ""))) != null) {
                SharedElementsFactory.INSTANCE.get(context).setPushTokenStatus(isTokenIdValue);
                ++migratedCount;
            }
            if ((uniqueIdIdValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(uniqueIdHashedKey = EncryptionManager.Companion.getHashed("com.flybits.device.unique_id"), ""))) != null) {
                SharedElementsFactory.INSTANCE.get(context).setUniqueDevice(uniqueIdIdValue);
                ++migratedCount;
            }
            if ((gatewayURLValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(gatewayURLHashedKey = EncryptionManager.Companion.getHashed("com.flybits.project.url"), ""))) != null) {
                SharedElementsFactory.INSTANCE.get(context).setGatewayURL(gatewayURLValue);
                ++migratedCount;
            }
            if ((idpConnectedValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(idpConnectedHashedKey = EncryptionManager.Companion.getHashed("com.flybits.idp.connected"), ""))) != null) {
                SharedElementsFactory.INSTANCE.get(context).setConnectedIDP(idpConnectedValue);
                ++migratedCount;
            }
            if ((notificationChannelIdValue = encryptionManager2.decrypt$commons_release(oldPreferences.getString(notificationChannelIdHashedKey = EncryptionManager.Companion.getHashed("com.flybits.idp.channel_id"), ""))) != null) {
                SharedElementsFactory.INSTANCE.get(context).setNotificationChannel(notificationChannelIdValue);
                ++migratedCount;
            }
            oldPreferences.edit().clear().commit();
            n = migratedCount;
        }
        catch (Exception e) {
            Logger.e("SecuredSharedElements.migrateV2() error: " + e.getMessage());
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int migrateV2$commons_release(@NotNull EncryptionManager encryptionManager2, @NotNull SharedPreferences oldPreferences) {
        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"com/flybits/commons/library/SecuredSharedElements$migrateV2$Key", "", "hashed", "", "unhashed", "(Ljava/lang/String;Ljava/lang/String;)V", "getHashed", "()Ljava/lang/String;", "getUnhashed", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lcom/flybits/commons/library/SecuredSharedElements$migrateV2$Key;", "equals", "", "other", "hashCode", "", "toString", "commons_release"})
        public final class Key {
            @NotNull
            private final String hashed;
            @NotNull
            private final String unhashed;

            public Key(@NotNull String hashed, @NotNull String unhashed) {
                Intrinsics.checkNotNullParameter((Object)hashed, (String)"hashed");
                Intrinsics.checkNotNullParameter((Object)unhashed, (String)"unhashed");
                this.hashed = hashed;
                this.unhashed = unhashed;
            }

            @NotNull
            public final String getHashed() {
                return this.hashed;
            }

            @NotNull
            public final String getUnhashed() {
                return this.unhashed;
            }

            @NotNull
            public final String component1() {
                return this.hashed;
            }

            @NotNull
            public final String component2() {
                return this.unhashed;
            }

            @NotNull
            public final Key copy(@NotNull String hashed, @NotNull String unhashed) {
                Intrinsics.checkNotNullParameter((Object)hashed, (String)"hashed");
                Intrinsics.checkNotNullParameter((Object)unhashed, (String)"unhashed");
                return new Key(hashed, unhashed);
            }

            public static /* synthetic */ Key copy$default(Key key, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = key.hashed;
                }
                if ((n & 2) != 0) {
                    string2 = key.unhashed;
                }
                return key.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Key(hashed=" + this.hashed + ", unhashed=" + this.unhashed + ')';
            }

            public int hashCode() {
                int result = this.hashed.hashCode();
                result = result * 31 + this.unhashed.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Key)) {
                    return false;
                }
                Key key = (Key)other;
                if (!Intrinsics.areEqual((Object)this.hashed, (Object)key.hashed)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.unhashed, (Object)key.unhashed);
            }
        }
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)encryptionManager2, (String)"encryptionManager");
        Intrinsics.checkNotNullParameter((Object)oldPreferences, (String)"oldPreferences");
        SecuredPreferenceStore securedPreferenceStore = SecuredPreferenceStore.Companion.getSharedInstance();
        SecuredPreferenceStore.Editor $this$migrateV2_u24lambda_u2d4 = securedPreferenceStore != null ? securedPreferenceStore.edit() : null;
        boolean bl = false;
        int migratedCount = 0;
        Object[] objectArray = new String[]{"com.flybits.jwt.token", "com.flybits.language.codes", "com.flybits.idp.connected"};
        Iterable $this$map$iv = SetsKt.setOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new Key(EncryptionManager.Companion.getHashed((String)it), (String)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String encryptedValue;
            Key it = (Key)element$iv;
            boolean bl3 = false;
            if (oldPreferences.getString(it.getHashed(), null) == null) continue;
            boolean bl4 = false;
            String decryptedValue = this.decrypt(encryptedValue, encryptionManager2);
            SecuredPreferenceStore.Editor editor = $this$migrateV2_u24lambda_u2d4;
            if (editor != null) {
                editor.putString(it.getUnhashed(), decryptedValue);
            }
            oldPreferences.edit().remove(it.getHashed()).apply();
            ++migratedCount;
        }
        SecuredPreferenceStore.Editor editor = $this$migrateV2_u24lambda_u2d4;
        if (editor != null) {
            editor.apply();
        }
        String string = SharedElements.Companion.getTAG$commons_release();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.appendTag(string).d("migrateV2() migrated " + migratedCount + " values to V2.");
        return migratedCount;
    }

    private final EncryptionManager.EncryptedData decodeEncryptedText(String text) {
        List list;
        CharSequence charSequence = text;
        Regex regex = new Regex("]");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] parts = stringArray;
        byte[] mac = null;
        if (parts.length > 2) {
            mac = EncryptionManager.Companion.base64Decode(parts[2]);
        }
        return new EncryptionManager.EncryptedData(EncryptionManager.Companion.base64Decode(parts[0]), EncryptionManager.Companion.base64Decode(parts[1]), mac);
    }

    private final String decrypt(String text, EncryptionManager encryptionManager2) throws IOException, NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, EncryptionManager.InvalidMacException, NoSuchProviderException, InvalidAlgorithmParameterException, KeyStoreException, UnrecoverableEntryException {
        if (text != null && ((CharSequence)text).length() > 0) {
            String string;
            EncryptionManager.EncryptedData encryptedData = this.decodeEncryptedText(text);
            byte[] decrypted = encryptionManager2.tryDecrypt$commons_release(encryptedData);
            if (decrypted == null) {
                string = null;
            } else {
                int n = 0;
                int n2 = decrypted.length;
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
                Charset charset2 = charset;
                string = new String(decrypted, n, n2, charset2);
            }
            return string;
        }
        return null;
    }

    @Override
    public void setStringVariable(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putString(key, value);
        editor.apply();
    }

    @Override
    public void setBooleanVariable(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putBoolean(key, value);
        editor.apply();
    }
}

