/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.LocaleList;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.flybits.commons.CommonScope;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.UnsecuredSharedElements;
import com.flybits.commons.library.analytics.Analytics;
import com.flybits.commons.library.api.CustomerStatus;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.FlybitsConfiguration;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.ScopeOfficer;
import com.flybits.commons.library.api.idps.HttpMethod;
import com.flybits.commons.library.api.idps.IDP;
import com.flybits.commons.library.api.idps.JwtIDP;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.DeserializeLogin;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidFlybitsManagerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.logging.VerbosityLevel;
import com.flybits.commons.library.models.Jwt;
import com.flybits.commons.library.models.PushProviderType;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.Utilities;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.CtxDataDAO;
import com.flybits.internal.db.UserDAO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class FlybitsManager {
    public static final String AUTHENTICATION_API = "/sso/auth";
    static final String DISCONNECT_ENDPOINT = "/sso/auth/logout";
    static final String DISABLE_PUSH = "/push/token";
    private static final String TAG_MANAGER = "Manager";
    private static final String ACTIVE_API = "/sso/auth/activationStatus";
    private Context context;
    private IDP idProvider;
    private Analytics analytics;
    private ArrayList<String> languageCodes;
    private SharedElements sharedElements;
    private boolean fallBackSPEncrypToMemo = false;
    private boolean keepSP = true;

    private FlybitsManager(Builder builder) {
        this.context = builder.mContext;
        this.languageCodes = builder.languageCodes;
        this.idProvider = builder.idProvider;
        this.analytics = new Analytics(this.context);
        this.fallBackSPEncrypToMemo = builder.failedEncryptedToMemory;
        this.keepSP = builder.retainSharedPref;
        this.sharedElements = SharedElementsFactory.INSTANCE.get(this.context, this.fallBackSPEncrypToMemo, this.keepSP);
        if (this.languageCodes.size() == 0) {
            this.languageCodes.add("en");
        }
        this.sharedElements.migrateData(this.context);
        this.sharedElements.setLocalization(this.languageCodes);
    }

    private static void parseConfigJson(FlybitsConfiguration flybitsConfiguration, Context context) {
        block20: {
            String configJson = null;
            try {
                String line;
                InputStream is = flybitsConfiguration.getApplicationContext().getAssets().open("FlybitsConfiguration.json");
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder stringBuilder = new StringBuilder();
                String ls = System.getProperty("line.separator");
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append(ls);
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                reader.close();
                configJson = stringBuilder.toString();
            }
            catch (IOException e) {
                Logger.appendTag("FlybitsConfigParser").e("No FlybitsConfiguration.json found, values can be set using builder pattern");
            }
            if (configJson != null) {
                try {
                    JSONObject jsonObject = new JSONObject(configJson).getJSONObject("projectConfiguration");
                    if (flybitsConfiguration.getProjectId().isEmpty()) {
                        flybitsConfiguration.setProjectId(jsonObject.getString("projectId"));
                    }
                    if (flybitsConfiguration.getGatewayUrl().isEmpty()) {
                        flybitsConfiguration.setGatewayUrl(jsonObject.getString("gatewayUrl"));
                    }
                    if (!flybitsConfiguration.getPushProviderFromJson().isEmpty()) break block20;
                    try {
                        flybitsConfiguration.setPushProviderFromJson(jsonObject.getString("pushProvider"));
                    }
                    catch (Exception e) {
                        flybitsConfiguration.setPushProviderFromJson("FCM");
                        Logger.appendTag("FlybitsConfigParser").e("No ${FlybitsConciergeConfiguration.PUSH_PROVIDER} found.");
                    }
                    switch (flybitsConfiguration.getPushProviderFromJson().toLowerCase()) {
                        case "gcm": {
                            SharedElementsFactory.INSTANCE.get(context).storePushProviderType(PushProviderType.GCM);
                            break;
                        }
                        case "fcm": {
                            SharedElementsFactory.INSTANCE.get(context).storePushProviderType(PushProviderType.FCM);
                            break;
                        }
                        case "huawei": {
                            SharedElementsFactory.INSTANCE.get(context).storePushProviderType(PushProviderType.HUAWEI);
                        }
                    }
                }
                catch (IllegalArgumentException | JSONException e) {
                    Logger.appendTag("FlybitsConfigParser").e("Failed to parse FlybitsConfiguration.", (Exception)e);
                }
            }
        }
    }

    public static void configure(@Nullable FlybitsConfiguration flybitsConfiguration, Context context) {
        FlybitsConfiguration config = flybitsConfiguration == null ? new FlybitsConfiguration.Builder(context).build() : flybitsConfiguration;
        FlybitsManager.parseConfigJson(config, context);
        SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(context);
        if (!(config.getGatewayUrl().equals("") || sharedElements.getGatewayURL().equals(config.getGatewayUrl()) || sharedElements.getSavedJWTToken().isEmpty())) {
            Logger.appendTag(TAG_MANAGER).e("You are trying to change the gatewayUrl with a user already connected to FlybitsgatewayUrl:" + sharedElements.getGatewayURL() + "You must disconnect your current session before connecting to a new gatewayUrl");
            return;
        }
        sharedElements.setGatewayURL(config.getGatewayUrl());
        if (sharedElements.getSavedJWTToken().isEmpty()) {
            CountDownLatch latch = new CountDownLatch(1);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.execute(() -> {
                CommonsDatabase commonsDatabase = CommonsDatabase.getDatabase(context);
                User user = commonsDatabase.userDao().getActiveUser();
                if (user != null) {
                    commonsDatabase.userDao().resetAllUsers();
                }
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Logger.exception("FlybitsManager.configure", e);
            }
        }
    }

    public static void addScope(@NonNull FlybitsScope scope, Context context) {
        ScopeOfficer.addScope(scope, context);
    }

    public static void removeScope(@NonNull FlybitsScope scope) {
        ScopeOfficer.removeScope(scope);
    }

    public static void setLoggingVerbosity(VerbosityLevel level) {
        Logger.setVerbosity(level);
    }

    static int getScopeSize() {
        return ScopeOfficer.getFlybitsScopes().size();
    }

    public static boolean isScopeExists(String scopeName) {
        return ScopeOfficer.getFlybitsScopes().containsKey(scopeName);
    }

    public static boolean isConnected(@NonNull Context context) {
        try {
            String savedJwt = SharedElementsFactory.INSTANCE.get(context).getSavedJWTToken();
            if (!savedJwt.isEmpty()) {
                return Jwt.decodeJWTToken(savedJwt).getExpiry() > new Date().getTime() / 1000L;
            }
            return false;
        }
        catch (Exception e) {
            Logger.appendTag(TAG_MANAGER).e("Failed to retrieve JWT information: " + e.toString());
            return false;
        }
    }

    public static void clearUnsecuredSharePref() {
        SharedElements sharedElements = SharedElementsFactory.savedInstance;
        if (sharedElements != null && sharedElements instanceof UnsecuredSharedElements) {
            sharedElements.setStringVariable("com.flybits.jwt.token", "");
            sharedElements.setStringVariable("com.flybits.idp.connected", "");
        }
    }

    public BasicResult optOut(BasicResultCallback callback) {
        return this.optOut(callback, new Handler());
    }

    BasicResult optOut(BasicResultCallback callback, Handler handler) {
        return this.setOptedState(false, callback, handler);
    }

    public BasicResult optIn(BasicResultCallback callback) {
        return this.optIn(callback, new Handler());
    }

    BasicResult optIn(BasicResultCallback callback, Handler handler) {
        return this.setOptedState(true, callback, handler);
    }

    BasicResult setOptedState(boolean optedState, BasicResultCallback callback, Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult query = new BasicResult(callback, handler, executorService);
        executorService.execute(() -> {
            Result result = FlyAway.post(this.context, ACTIVE_API, String.format("{\"%s\":%s}", "isActive", optedState), null, "FlybitsManager.setOptedState", null);
            if (result.getStatus() == RequestStatus.COMPLETED) {
                SharedElements sharedElements;
                User userObj;
                CommonsDatabase commonsDatabase = CommonsDatabase.getDatabase(this.context);
                if (!optedState) {
                    this.analytics.destroy();
                    commonsDatabase.ctxDataDAO().deleteAll();
                    commonsDatabase.preferenceDAO().clear();
                    commonsDatabase.cachingEntryDAO().clear();
                } else {
                    this.analytics.scheduleWorkers();
                }
                User user = commonsDatabase.userDao().getActiveUser();
                if (user != null) {
                    user.setOptedIn(optedState);
                    commonsDatabase.userDao().update(user);
                }
                if ((userObj = (sharedElements = SharedElementsFactory.INSTANCE.get(this.context)).getUser()) != null) {
                    userObj.setOptedIn(optedState);
                    sharedElements.setUser(userObj);
                }
                ScopeOfficer.INSTANCE.onOptedStateChange(this.context, optedState);
                query.setResult(result);
            } else {
                query.setFailed(result.getException());
            }
        });
        return query;
    }

    BasicResult connect(BasicResultCallback callback, @NonNull Handler handler) {
        return this.connect(callback, true, handler, null);
    }

    public BasicResult connect(BasicResultCallback callback) {
        return this.connect(callback, true);
    }

    public BasicResult connect(@NonNull IDP idp, BasicResultCallback callback) {
        this.idProvider = idp;
        return this.connect(callback, true);
    }

    public BasicResult connect(@NonNull IDP idp, @NonNull String customerId, BasicResultCallback callback) {
        return this.connect(idp, callback, customerId, new Handler(Looper.getMainLooper()));
    }

    BasicResult connect(@NonNull IDP idp, BasicResultCallback callback, @NonNull String customerId, @NonNull Handler handler) {
        this.idProvider = idp;
        return this.connect(callback, true, handler, customerId);
    }

    public BasicResult connect(@NonNull IDP idp, @Nullable String customerId, @NonNull String deviceId, @NonNull BasicResultCallback callback) {
        this.idProvider = idp;
        this.sharedElements.setUniqueDevice(deviceId);
        return this.connect(callback, true, new Handler(Looper.getMainLooper()), customerId);
    }

    BasicResult connect(BasicResultCallback callback, boolean autoUseManifestProject, @NonNull Handler handler, String customerId) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult query = new BasicResult(callback, handler, executorService);
        executorService.execute(() -> {
            if (FlybitsManager.isConnected(this.context)) {
                FlybitsException e = new FlybitsException("You already have an IDP connected to the Flybits SDK, please call the disconnect method before calling connect again");
                query.setFailed(e);
            } else if (this.idProvider != null) {
                ScopeOfficer.INSTANCE.onConnecting();
                String body2 = "";
                if (this.idProvider.getBody() != null) {
                    body2 = this.idProvider.getBody().toString();
                }
                String url = AUTHENTICATION_API + this.idProvider.getAuthenticationEndPoint();
                HttpMethod requestType = this.idProvider.getRequestType();
                if (this.idProvider instanceof JwtIDP) {
                    url = this.idProvider.getAuthenticationEndPoint();
                    Result updateUserAgent = FlyAway.post(this.context, url, "", null, "Device.userAgent", null, this.idProvider.getHeaders());
                    if (updateUserAgent.getStatus() == RequestStatus.COMPLETED) {
                        String userEndpoint = AUTHENTICATION_API + ((JwtIDP)this.idProvider).getUserInfoEndPoint();
                        Result<User> authenticatedUser = FlyAway.get(this.context, userEndpoint, this.idProvider.getHeaders(), new DeserializeLogin(), "FlybitsManager.connect", User.class);
                        this.connectUserAuthenticate(authenticatedUser, customerId, query);
                    } else {
                        this.sharedElements.setJWTToken("");
                        this.sharedElements.setUser(null);
                        ScopeOfficer.INSTANCE.onFailedToConnect(this.context);
                        query.setFailed(new FlybitsException("Authentication Failed."));
                    }
                } else {
                    Result<User> authenticatedUser = requestType.equals((Object)HttpMethod.GET) ? FlyAway.get(this.context, url, this.idProvider.getHeaders(), new DeserializeLogin(), "FlybitsManager.connect", User.class) : (requestType.equals((Object)HttpMethod.PUT) ? FlyAway.put(this.context, url, body2, new DeserializeLogin(), "FlybitsManager.connect", User.class, this.idProvider.getHeaders()) : FlyAway.post(this.context, url, body2, new DeserializeLogin(), "FlybitsManager.connect", User.class, this.idProvider.getHeaders()));
                    this.connectUserAuthenticate(authenticatedUser, customerId, query);
                }
            }
        });
        return query;
    }

    private void connectUserAuthenticate(Result<User> authenticatedUser, String customerId, BasicResult query) {
        if (authenticatedUser.getStatus() == RequestStatus.COMPLETED) {
            User user = authenticatedUser.getResponse();
            UserDAO userDAO = CommonsDatabase.getDatabase(this.context).userDao();
            userDAO.resetAllUsers();
            CtxDataDAO ctxDataDAO = CommonsDatabase.getDatabase(this.context).ctxDataDAO();
            ctxDataDAO.deleteAll();
            if (customerId != null && !customerId.isEmpty()) {
                user.setCustomerID(customerId);
            }
            userDAO.insert(user);
            this.sharedElements.setConnectedIDP(this.idProvider.getProvider());
            this.sharedElements.setUser(user);
            this.sharedElements.setUserId(authenticatedUser.getResponse().getId());
            this.idProvider.onAuthenticated(this.context, user);
            this.analytics.scheduleWorkers();
            ScopeOfficer.INSTANCE.onConnected(this.context, user);
            query.setResult(authenticatedUser);
        } else {
            ScopeOfficer.INSTANCE.onFailedToConnect(this.context);
            query.setFailed(authenticatedUser.getException());
        }
    }

    public BasicResult connect(BasicResultCallback callback, boolean autoUseManifestProject) {
        if (this.idProvider == null) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            BasicResult query = new BasicResult(callback, new Handler(Looper.getMainLooper()), executorService);
            FlybitsException e = new FlybitsException("You must enter an IDP in the Flybits Builder to use this connect() method.");
            callback.onException(e);
            return query;
        }
        return this.connect(callback, autoUseManifestProject, new Handler(Looper.getMainLooper()), null);
    }

    public BasicResult disconnect(BasicResultCallback callback) {
        return this.disconnect(callback, false);
    }

    BasicResult disconnect(BasicResultCallback callback, boolean disconnectOnException, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(() -> {
            try {
                this.analytics.flush(null, false);
                Result<?> disconnected = FlyAway.delete(this.context, DISABLE_PUSH, "PushManager.disablePush", null);
                if (disconnected.getStatus() == RequestStatus.COMPLETED || disconnectOnException) {
                    Utilities.clearSDKData(this.context, this.analytics);
                    this.sharedElements.setPushTokenStatus("deleted");
                    ScopeOfficer.INSTANCE.onDisconnected(this.context);
                    request.setResult(new Result(200, ""));
                } else {
                    this.sharedElements.setPushTokenStatus("unknown");
                    if (disconnected.getStatus() == RequestStatus.OPTED_OUT) {
                        Utilities.clearSDKData(this.context, this.analytics);
                        ScopeOfficer.INSTANCE.onDisconnected(this.context);
                        request.setResult(new Result(200, ""));
                    } else {
                        if (disconnectOnException) {
                            Utilities.clearSDKData(this.context, this.analytics);
                            ScopeOfficer.INSTANCE.onDisconnected(this.context);
                        }
                        request.setFailed(disconnected.getException());
                    }
                }
            }
            catch (FlybitsException e) {
                this.sharedElements.setPushTokenStatus("unknown");
                if (disconnectOnException) {
                    Utilities.clearSDKData(this.context, this.analytics);
                    ScopeOfficer.INSTANCE.onDisconnected(this.context);
                }
                request.setFailed(e);
            }
        });
        return request;
    }

    BasicResult disconnect(BasicResultCallback callback, @NonNull Handler handler) {
        return this.disconnect(callback, false, handler);
    }

    public BasicResult disconnect(BasicResultCallback callback, boolean disconnectOnException) {
        return this.disconnect(callback, disconnectOnException, new Handler(Looper.getMainLooper()));
    }

    public ObjectResult<CustomerStatus> checkCustomerIdStatus(@NonNull String customerId, ObjectResultCallback<CustomerStatus> callback) {
        return this.checkCustomerIdStatus(customerId, callback, new Handler(Looper.getMainLooper()));
    }

    ObjectResult<CustomerStatus> checkCustomerIdStatus(@NonNull String customerId, ObjectResultCallback<CustomerStatus> callback, Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ObjectResult<CustomerStatus> query = new ObjectResult<CustomerStatus>(callback, handler, executorService);
        String savedJwt = this.sharedElements.getSavedJWTToken();
        executorService.execute(() -> {
            UserDAO userDAO = CommonsDatabase.getDatabase(this.context).userDao();
            if (!savedJwt.isEmpty()) {
                Jwt jwt = Jwt.decodeJWTToken(savedJwt);
                long timeEpochTimeSeconds = new Date().getTime() / 1000L;
                User user = userDAO.getSingleByUserAndCustomerId(jwt.getUserID(), customerId);
                this.setUserStatus(jwt, timeEpochTimeSeconds, user, query, customerId, userDAO);
            } else {
                query.setSuccess(CustomerStatus.NOT_CONNECTED);
            }
        });
        return query;
    }

    public ObjectResult<CustomerStatus> checkUserStatus(ObjectResultCallback<CustomerStatus> callback) {
        return this.checkUserStatus(callback, new Handler(Looper.getMainLooper()));
    }

    ObjectResult<CustomerStatus> checkUserStatus(ObjectResultCallback<CustomerStatus> callback, Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ObjectResult<CustomerStatus> query = new ObjectResult<CustomerStatus>(callback, handler, executorService);
        String savedJwt = this.sharedElements.getSavedJWTToken();
        executorService.execute(() -> {
            UserDAO userDAO = CommonsDatabase.getDatabase(this.context).userDao();
            if (!savedJwt.isEmpty()) {
                Jwt jwt = Jwt.decodeJWTToken(savedJwt);
                long timeEpochTimeSeconds = new Date().getTime() / 1000L;
                User user = userDAO.getSingleById(jwt.getUserID());
                this.setUserStatus(jwt, timeEpochTimeSeconds, user, query, null, null);
            } else {
                query.setSuccess(CustomerStatus.NOT_CONNECTED);
            }
        });
        return query;
    }

    private void setUserStatus(Jwt jwt, Long timeEpochTimeSeconds, User user, ObjectResult<CustomerStatus> query, @Nullable String customerId, @Nullable UserDAO userDAO) {
        if (user != null) {
            if (user.isOptedIn() && jwt.getExpiry() > timeEpochTimeSeconds) {
                query.setSuccess(CustomerStatus.CONNECTED_OPTED_IN);
            } else if (user.isOptedIn() && jwt.getExpiry() < timeEpochTimeSeconds) {
                query.setSuccess(CustomerStatus.CONNECTED_OPTED_IN_EXPIRED_TOKEN);
            } else if (!user.isOptedIn() && jwt.getExpiry() > timeEpochTimeSeconds) {
                query.setSuccess(CustomerStatus.CONNECTED_OPTED_OUT);
            } else if (!user.isOptedIn() && jwt.getExpiry() < timeEpochTimeSeconds) {
                query.setSuccess(CustomerStatus.CONNECTED_OPTED_OUT_EXPIRED_TOKEN);
            }
        } else if (customerId == null) {
            query.setSuccess(CustomerStatus.NOT_CONNECTED);
        } else if (userDAO != null) {
            user = userDAO.getSingleByCustomerId(customerId);
            if (user != null) {
                if (user.isOptedIn()) {
                    query.setSuccess(CustomerStatus.NOT_CONNECTED_OPTED_IN);
                } else {
                    query.setSuccess(CustomerStatus.NOT_CONNECTED_OPTED_OUT);
                }
            } else {
                query.setSuccess(CustomerStatus.NOT_CONNECTED);
            }
        }
    }

    public User getActiveUser(Context context) {
        if (FlybitsManager.isConnected(context)) {
            SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(context);
            try {
                return sharedElements.getUser();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    IDP getIDP() {
        return this.idProvider;
    }

    public static final class Builder {
        private final Set<FlybitsScope> listOfScopes;
        private Context mContext;
        private IDP idProvider;
        private ArrayList<String> languageCodes;
        private Boolean failedEncryptedToMemory = false;
        private Boolean retainSharedPref = true;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.listOfScopes = new HashSet<FlybitsScope>();
            this.languageCodes = new ArrayList();
            try {
                if (Build.VERSION.SDK_INT >= 24) {
                    LocaleList localeList = LocaleList.getAdjustedDefault();
                    for (int i = 0; i < localeList.size(); ++i) {
                        Locale locale = localeList.get(i);
                        this.languageCodes.add(locale.getLanguage());
                    }
                } else {
                    this.languageCodes.add(Locale.getDefault().getLanguage());
                }
            }
            catch (Exception e) {
                Logger.exception("FlybitsManager.Builder", e);
            }
            this.listOfScopes.add(new CommonScope(this.mContext));
        }

        public FlybitsManager build() throws InvalidFlybitsManagerException {
            this.checkIfFieldsSet();
            for (FlybitsScope listOfScope : this.listOfScopes) {
                FlybitsManager.addScope(listOfScope, this.mContext);
            }
            return new FlybitsManager(this);
        }

        public Builder setAccount(IDP idp) {
            this.idProvider = idp;
            return this;
        }

        public Builder setLanguage(@NonNull String languageCode) {
            this.languageCodes.clear();
            this.languageCodes.add(languageCode);
            return this;
        }

        private void checkIfFieldsSet() throws InvalidFlybitsManagerException {
            if (this.languageCodes.size() > 0 && this.languageCodes.get(0).length() != 2) {
                throw new InvalidFlybitsManagerException("Your language must be a 2-letter code. Make sure you call setLanguage(String)");
            }
        }

        public Builder setFailedEncryptedToMemory(Boolean memoryOnly) {
            this.failedEncryptedToMemory = memoryOnly;
            return this;
        }

        public Builder setKeepSharedPref(Boolean retainSharedPref) {
            this.retainSharedPref = retainSharedPref;
            return this;
        }
    }
}

