package com.flybits.commons.library.utils.jbool_expressions;

import java.util.Comparator;
import java.util.List;
import java.util.Map;

import static com.flybits.commons.library.utils.jbool_expressions.Seeds.OR_SEED;

/**
 * Implementation of Operator NONE.
 */
final public class None<K> extends NExpression<K> {
    public static final String EXPR_TYPE = "none";
    private String cachedStringRepresentation = null;

    private None(Expression<K>[] children, Comparator<Expression> comparator) {
        super(children, OR_SEED, comparator);
    }

    public static <K> None<K> of(Expression<K>[] children, Comparator<Expression> comparator) {
        return new None<K>(children, comparator);
    }

    @SafeVarargs
    public static <K> None<K> of(Expression<K>... children) {
        return new None<>(children, HASH_COMPARATOR);
    }

    public static <K> None<K> of(Expression<K> child1, Expression<K> child2, Expression<K> child3,
            Expression<K> child4) {
        return of(ExprUtil.<K>list(child1, child2, child3, child4));
    }

    public static <K> None<K> of(Expression<K> child1, Expression<K> child2, Expression<K> child3) {
        return of(ExprUtil.<K>list(child1, child2, child3));
    }

    public static <K> None<K> of(Expression<K> child1, Expression<K> child2) {
        return of(ExprUtil.<K>list(child1, child2));
    }

    public static <K> None<K> of(Expression<K> child1) {
        return of(ExprUtil.<K>list(child1));
    }

    public static <K> None<K> of(List<? extends Expression<K>> children) {
        return of(children.toArray(new Expression[children.size()]), HASH_COMPARATOR);
    }

    @Override
    public NExpression<K> create(Expression<K>[] children, Comparator<Expression> comparator) {
        return of(children, comparator);
    }

    public String toString() {
        if (cachedStringRepresentation == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            for (int i = 0; i < expressions.length; i++) {
                stringBuilder.append(expressions[i].toString());
                if (i < expressions.length - 1) {
                    stringBuilder.append("");
                }
            }
            stringBuilder.append(")");
            cachedStringRepresentation = stringBuilder.toString();
        }
        return cachedStringRepresentation;
    }

    @Override
    public String getExprType() {
        return EXPR_TYPE;
    }

    public Expression<K> replaceVars(Map<K, Expression<K>> m) {
        Expression<K>[] children = new Expression[this.expressions.length];
        for (int i = 0; i < this.expressions.length; i++) {
            children[i] = this.expressions[i].replaceVars(m);
        }
        return of(children);
    }
}
