package com.flybits.commons.library.api.idps

import android.os.Parcel
import android.os.Parcelable
import android.util.Base64
import com.flybits.commons.library.utils.Utilities.setValuesToBody
import org.json.JSONObject

/**
 * The [APIKeyIDP] class is responsible for logging into the Flybits system using an API key generated in the
 * developer portal for a specific project
 *
 * @param apiKey The API key generated from the developer portal
 * @param email Account with which you wish to login
 */
class APIKeyIDP(private val apiKey: String?, private val email: String?)
    : IDP("apikey") {

    private var accessToken : String = ""

    init {
        val bodyObject = JSONObject()
        setValuesToBody("apikey", apiKey, bodyObject)
        setValuesToBody("email", email, bodyObject)

        accessToken = encodeString(bodyObject.toString())
    }

    override fun getBody(): JSONObject {

        val bodyObject = JSONObject()

        setValuesToBody("projectId", getProjectID(), bodyObject)
        setValuesToBody("provider", "apikey", bodyObject)
        setValuesToBody("accessToken", accessToken, bodyObject)

        return bodyObject
    }

    override val authenticationEndPoint: String
        get() = "/oauth"

    private constructor(parcel: Parcel) : this(
            parcel.readString(),
            parcel.readString())

    override fun writeToParcel(out: Parcel, flags: Int) {
        out.writeString(apiKey)
        out.writeString(email)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object {
        @JvmField val CREATOR : Parcelable.Creator<APIKeyIDP?> = object : Parcelable.Creator<APIKeyIDP?> {
            override fun createFromParcel(parcel: Parcel): APIKeyIDP {
                return APIKeyIDP(parcel)
            }

            override fun newArray(size: Int): Array<APIKeyIDP?> {
                return arrayOfNulls(size)
            }
        }
    }

    private fun encodeString(json: String): String {
        return Base64.encodeToString(json.toByteArray(), Base64.NO_WRAP)
    }
}