/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal;

import com.flybits.internal.Debounce;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class Debouncer {
    private static Debouncer mInstance = null;
    private final ScheduledExecutorService sched = Executors.newScheduledThreadPool(1);
    private final ConcurrentHashMap<Debounce, TimerTask> delayedMap = new ConcurrentHashMap();
    private boolean reRun;

    private Debouncer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Debouncer getInstance() {
        if (mInstance != null) return mInstance;
        Class<Debouncer> clazz = Debouncer.class;
        synchronized (Debouncer.class) {
            if (mInstance != null) return mInstance;
            mInstance = new Debouncer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void call(Debounce task) {
        if (!this.delayedMap.containsKey(task)) {
            TimerTask timerTask = new TimerTask(task);
            this.delayedMap.put(task, timerTask);
            task.doSomething();
            this.sched.schedule(timerTask, task.getWait(), task.getUnit());
        } else {
            this.reRun = true;
        }
    }

    public void cancel(Debounce task) {
        if (this.delayedMap.containsKey(task)) {
            this.reRun = false;
        }
    }

    private class TimerTask
    implements Runnable {
        private final Debounce event;
        private final Object lock = new Object();

        TimerTask(Debounce event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                if (Debouncer.this.reRun) {
                    Debouncer.this.reRun = false;
                    this.event.doSomething();
                    Debouncer.this.sched.schedule(this, this.event.getWait(), this.event.getUnit());
                } else {
                    Debouncer.this.delayedMap.remove(this.event);
                }
            }
        }
    }
}

