/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.LocaleList;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.analytics.Analytics;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import com.flybits.internal.db.CommonsDatabase;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J$\u0010\u000e\u001a\u00020\u00042\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0010j\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\u0011H\u0007J\"\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0010j\b\u0012\u0004\u0012\u00020\u0004`\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J \u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0010j\b\u0012\u0004\u0012\u00020\u0004`\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0017H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/flybits/commons/library/utils/Utilities;", "", "()V", "sDKVersion", "", "getSDKVersion$annotations", "getSDKVersion", "()Ljava/lang/String;", "clearSDKData", "", "context", "Landroid/content/Context;", "analytics", "Lcom/flybits/commons/library/analytics/Analytics;", "convertLocalizationCodeToString", "listOfCodes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "convertLocalizationStringToList", "languageCodeAsString", "getDeviceLanguageCodes", "getUserAgentAsJSON", "setValuesToBody", "Lorg/json/JSONObject;", "strKey", "strValue", "bodyObject", "toRTF", "rtfString", "commons_release"})
public final class Utilities {
    @NotNull
    public static final Utilities INSTANCE = new Utilities();

    private Utilities() {
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<String> convertLocalizationStringToList(@Nullable String languageCodeAsString) {
        if (languageCodeAsString == null || ((CharSequence)languageCodeAsString).length() == 0) {
            return new ArrayList<String>();
        }
        String[] stringArray = new String[]{","};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)languageCodeAsString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] listOfCodes = stringArray2;
        return new ArrayList<String>((Collection)Arrays.asList(Arrays.copyOf(listOfCodes, listOfCodes.length)));
    }

    @JvmStatic
    @NotNull
    public static final String convertLocalizationCodeToString(@Nullable ArrayList<String> listOfCodes) {
        if (listOfCodes != null && listOfCodes.size() > 0) {
            String string = listOfCodes.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"listOfCodes[0]");
            String languageCodeString = string;
            int n = listOfCodes.size();
            for (int i = 1; i < n; ++i) {
                languageCodeString = languageCodeString + ',' + listOfCodes.get(i);
            }
            return languageCodeString;
        }
        return "";
    }

    @Nullable
    public static final String getSDKVersion() {
        return "X.X.X";
    }

    @JvmStatic
    public static /* synthetic */ void getSDKVersion$annotations() {
    }

    @JvmStatic
    @Nullable
    public static final String getUserAgentAsJSON(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JSONObject obj = new JSONObject();
        try {
            obj.put("make", (Object)Build.MANUFACTURER);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("model", (Object)Build.MODEL);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("osVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("deviceType", (Object)"Android");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(context);
            obj.put("physicalDeviceId", (Object)sharedElements.getUniqueDeviceId());
        }
        catch (Exception sharedElements) {
            // empty catch block
        }
        try {
            obj.put("sdkVersion", (Object)INSTANCE.getSDKVersion());
        }
        catch (JSONException sharedElements) {
            // empty catch block
        }
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager\n \u2026ageManager.GET_META_DATA)");
            ApplicationInfo ai = applicationInfo;
            Bundle bundle = ai.metaData;
            if (bundle.containsKey("com.flybits.device.name")) {
                String name = bundle.getString("com.flybits.device.name");
                obj.put("name", (Object)name);
            } else {
                obj.put("name", (Object)(Build.MANUFACTURER + '-' + Build.MODEL));
            }
        }
        catch (Exception e) {
            Logger.exception("getUserAgentAsJSON", e);
        }
        return obj.toString();
    }

    @JvmStatic
    @NotNull
    public static final String toRTF(@NotNull String rtfString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)rtfString, (String)"rtfString");
        try {
            String string2 = URLDecoder.decode(rtfString, StandardCharsets.UTF_8.name());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            URLDecoder\u2026s.UTF_8.name())\n        }");
            string = string2;
        }
        catch (UnsupportedEncodingException e) {
            string = rtfString;
        }
        catch (IllegalArgumentException e) {
            string = rtfString;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<String> getDeviceLanguageCodes(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList<String> languageCodes = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = LocaleList.getAdjustedDefault();
            Intrinsics.checkNotNullExpressionValue((Object)localeList, (String)"getAdjustedDefault()");
            LocaleList localeList2 = localeList;
            int n = localeList2.size();
            for (int i = 0; i < n; ++i) {
                Locale locale = localeList2.get(i);
                languageCodes.add(locale.getLanguage());
            }
        } else {
            languageCodes.add(Locale.getDefault().getLanguage());
        }
        SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(context);
        sharedElements.setLocalization(languageCodes);
        return languageCodes;
    }

    @JvmStatic
    @NotNull
    public static final JSONObject setValuesToBody(@NotNull String strKey, @Nullable String strValue, @NotNull JSONObject bodyObject) {
        Intrinsics.checkNotNullParameter((Object)strKey, (String)"strKey");
        Intrinsics.checkNotNullParameter((Object)bodyObject, (String)"bodyObject");
        try {
            bodyObject.put(strKey, (Object)strValue);
        }
        catch (JSONException e) {
            Logger.appendTag("UtilityTag").d("Invalid JsonObject");
        }
        return bodyObject;
    }

    @JvmStatic
    public static final void clearSDKData(@NotNull Context context, @Nullable Analytics analytics) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Analytics analytics2 = analytics;
        if (analytics2 != null) {
            analytics2.destroy();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            Utilities $this$clearSDKData_u24lambda_u2d0 = INSTANCE;
            boolean bl = false;
            new Analytics(context).destroy();
        }
        SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(context);
        CommonsDatabase commonsDatabase = CommonsDatabase.getDatabase(context);
        User user = commonsDatabase.userDao().getActiveUser();
        if (user != null) {
            user.setActive(false);
            commonsDatabase.userDao().update(user);
        }
        commonsDatabase.ctxDataDAO().deleteAll();
        commonsDatabase.preferenceDAO().clear();
        commonsDatabase.cachingEntryDAO().clear();
        sharedElements.setJWTToken("");
        sharedElements.setConnectedIDP("");
        sharedElements.setUser(null);
    }

    public static /* synthetic */ void clearSDKData$default(Context context, Analytics analytics, int n, Object object) {
        if ((n & 2) != 0) {
            analytics = null;
        }
        Utilities.clearSDKData(context, analytics);
    }
}

