/*
 * Decompiled with CFR 0.152.
 */
package com.flowcentraltech.flowcentral.chart.data;

import com.flowcentraltech.flowcentral.configuration.constants.ChartSeriesDataType;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.DataUtils;
import java.util.List;

public abstract class ChartSeries<T extends Number> {
    private String name;
    private List<T> data;

    protected ChartSeries(String name, List<T> data) {
        this.name = name;
        this.data = DataUtils.unmodifiableList(data);
    }

    protected ChartSeries(String name, T[] data) {
        this.name = name;
        this.data = DataUtils.unmodifiableList((Object[])data);
    }

    public abstract ChartSeriesDataType getSeriesType();

    public abstract Class<T> getDataType();

    public String getName() {
        return this.name;
    }

    public List<T> getData() {
        return this.data;
    }

    public T[] dataToArray() {
        return (Number[])DataUtils.toArray(this.getDataType(), this.data);
    }

    public String dataToJsonArrayString() throws UnifyException {
        return DataUtils.asJsonArrayString((Object[])this.dataToArray());
    }

    public int size() {
        return this.data.size();
    }
}

