/*
 * Decompiled with CFR 0.152.
 */
package com.flowcentraltech.flowcentral.chart.business;

import com.flowcentraltech.flowcentral.chart.entities.Chart;
import com.flowcentraltech.flowcentral.chart.entities.ChartQuery;
import com.flowcentraltech.flowcentral.common.business.AbstractApplicationArtifactInstaller;
import com.flowcentraltech.flowcentral.common.constants.ConfigType;
import com.flowcentraltech.flowcentral.common.entities.ConfigEntity;
import com.flowcentraltech.flowcentral.common.util.ConfigUtils;
import com.flowcentraltech.flowcentral.configuration.data.ApplicationInstall;
import com.flowcentraltech.flowcentral.configuration.xml.AppChartConfig;
import com.flowcentraltech.flowcentral.configuration.xml.AppConfig;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.database.Entity;
import com.tcdng.unify.core.database.Query;
import com.tcdng.unify.core.task.TaskMonitor;
import com.tcdng.unify.core.util.DataUtils;
import java.util.Collection;

@Component(value="application-chartinstaller")
public class ApplicationChartInstallerImpl
extends AbstractApplicationArtifactInstaller {
    public void installApplicationArtifacts(TaskMonitor taskMonitor, ApplicationInstall applicationInstall) throws UnifyException {
        AppConfig applicationConfig = applicationInstall.getApplicationConfig();
        Long applicationId = applicationInstall.getApplicationId();
        this.logDebug(taskMonitor, "Executing chart installer...", new Object[0]);
        if (applicationConfig.getChartsConfig() != null && !DataUtils.isBlank((Collection)applicationConfig.getChartsConfig().getChartList())) {
            for (AppChartConfig appChartConfig : applicationConfig.getChartsConfig().getChartList()) {
                String description = this.resolveApplicationMessage(appChartConfig.getDescription(), new Object[0]);
                String title = this.resolveApplicationMessage(appChartConfig.getTitle(), new Object[0]);
                String subTitle = this.resolveApplicationMessage(appChartConfig.getSubTitle(), new Object[0]);
                this.logDebug(taskMonitor, "Installing chart chart [{0}]...", new Object[]{description});
                Chart oldChart = (Chart)this.environment().findLean((Query)new ChartQuery().applicationId(applicationId).name(appChartConfig.getName()));
                if (oldChart == null) {
                    Chart chart = new Chart();
                    chart.setApplicationId(applicationId);
                    chart.setType(appChartConfig.getType());
                    chart.setPaletteType(appChartConfig.getPaletteType());
                    chart.setName(appChartConfig.getName());
                    chart.setDescription(description);
                    chart.setTitle(title);
                    chart.setSubTitle(subTitle);
                    chart.setWidth(appChartConfig.getWidth());
                    chart.setHeight(appChartConfig.getHeight());
                    chart.setProvider(appChartConfig.getProvider());
                    chart.setRule(appChartConfig.getRule());
                    chart.setShowGrid(appChartConfig.isShowGrid());
                    chart.setShowDataLabels(appChartConfig.isShowDataLabels());
                    chart.setStacked(appChartConfig.isStacked());
                    chart.setSmooth(appChartConfig.isSmooth());
                    chart.setConfigType(ConfigType.MUTABLE_INSTALL);
                    this.environment().create((Entity)chart);
                    continue;
                }
                if (!ConfigUtils.isSetInstall((ConfigEntity)oldChart)) continue;
                oldChart.setType(appChartConfig.getType());
                oldChart.setPaletteType(appChartConfig.getPaletteType());
                oldChart.setDescription(description);
                oldChart.setTitle(title);
                oldChart.setSubTitle(subTitle);
                oldChart.setWidth(appChartConfig.getWidth());
                oldChart.setHeight(appChartConfig.getHeight());
                oldChart.setProvider(appChartConfig.getProvider());
                oldChart.setRule(appChartConfig.getRule());
                oldChart.setShowGrid(appChartConfig.isShowGrid());
                oldChart.setShowDataLabels(appChartConfig.isShowDataLabels());
                oldChart.setStacked(appChartConfig.isStacked());
                oldChart.setSmooth(appChartConfig.isSmooth());
                this.environment().updateByIdVersion((Entity)oldChart);
            }
        }
    }
}

