/*
 * Decompiled with CFR 0.152.
 */
package com.flowcentraltech.flowcentral.chart.data;

import com.flowcentraltech.flowcentral.chart.data.ChartCategories;
import com.flowcentraltech.flowcentral.chart.data.ChartSeries;
import com.flowcentraltech.flowcentral.chart.data.DateChartCategories;
import com.flowcentraltech.flowcentral.chart.data.DoubleChartSeries;
import com.flowcentraltech.flowcentral.chart.data.IntegerChartCategories;
import com.flowcentraltech.flowcentral.chart.data.IntegerChartSeries;
import com.flowcentraltech.flowcentral.chart.data.LongChartCategories;
import com.flowcentraltech.flowcentral.chart.data.LongChartSeries;
import com.flowcentraltech.flowcentral.chart.data.StringChartCategories;
import com.flowcentraltech.flowcentral.configuration.constants.ChartCategoryDataType;
import com.flowcentraltech.flowcentral.configuration.constants.ChartSeriesDataType;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.DataUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ChartData {
    private ChartCategories<?> categories;
    private List<ChartSeries<?>> series;

    private ChartData(ChartCategories<?> categories, List<ChartSeries<?>> series) {
        this.categories = categories;
        this.series = series;
    }

    public ChartCategories<?> getCategories() {
        return this.categories;
    }

    public List<ChartSeries<?>> getSeries() {
        return this.series;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ChartCategories<?> categories;
        private List<ChartSeries<?>> series = new ArrayList();

        public Builder categories(ChartCategoryDataType type, String categoriesJson) throws UnifyException {
            switch (type) {
                case DATE: {
                    this.categories = new DateChartCategories((Date[])DataUtils.convert(Date[].class, (Object)DataUtils.fromJsonString(Long[].class, (String)categoriesJson)));
                    break;
                }
                case INTEGER: {
                    this.categories = new IntegerChartCategories((Integer[])DataUtils.fromJsonString(Integer[].class, (String)categoriesJson));
                    break;
                }
                case LONG: {
                    this.categories = new LongChartCategories((Long[])DataUtils.fromJsonString(Long[].class, (String)categoriesJson));
                    break;
                }
                case STRING: {
                    this.categories = new StringChartCategories((String[])DataUtils.fromJsonString(String[].class, (String)categoriesJson));
                    break;
                }
            }
            return this;
        }

        public Builder addSeries(ChartSeriesDataType type, String name, String seriesJson) throws UnifyException {
            switch (type) {
                case DOUBLE: {
                    this.series.add(new DoubleChartSeries(name, (Double[])DataUtils.fromJsonString(Double[].class, (String)seriesJson)));
                    break;
                }
                case INTEGER: {
                    this.series.add(new IntegerChartSeries(name, (Integer[])DataUtils.fromJsonString(Integer[].class, (String)seriesJson)));
                    break;
                }
                case LONG: {
                    this.series.add(new LongChartSeries(name, (Long[])DataUtils.fromJsonString(Long[].class, (String)seriesJson)));
                    break;
                }
            }
            return this;
        }

        public ChartData build() throws UnifyException {
            if (this.categories == null) {
                throw new RuntimeException("Chart categories is required.");
            }
            if (this.series.size() == 0) {
                throw new RuntimeException("At least one series is required.");
            }
            return new ChartData(this.categories, this.series);
        }
    }
}

