/*
 * Decompiled with CFR 0.152.
 */
package com.flowcentraltech.flowcentral.chart.util;

import com.flowcentraltech.flowcentral.chart.data.ChartCategories;
import com.flowcentraltech.flowcentral.chart.data.ChartData;
import com.flowcentraltech.flowcentral.chart.data.ChartDef;
import com.flowcentraltech.flowcentral.chart.data.ChartSeries;
import com.flowcentraltech.flowcentral.chart.data.DateChartCategories;
import com.flowcentraltech.flowcentral.chart.data.DoubleChartSeries;
import com.flowcentraltech.flowcentral.chart.data.IntegerChartCategories;
import com.flowcentraltech.flowcentral.chart.data.IntegerChartSeries;
import com.flowcentraltech.flowcentral.chart.data.LongChartCategories;
import com.flowcentraltech.flowcentral.chart.data.LongChartSeries;
import com.flowcentraltech.flowcentral.chart.data.StringChartCategories;
import com.flowcentraltech.flowcentral.configuration.constants.ChartCategoryDataType;
import com.flowcentraltech.flowcentral.configuration.constants.ChartType;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.json.JsonWriter;

public final class ChartUtils {
    private ChartUtils() {
    }

    public static JsonWriter getOptionsJsonWriter(ChartDef chartDef, ChartData chartData, boolean sparkLine) throws UnifyException {
        JsonWriter jw = new JsonWriter();
        jw.beginObject();
        ChartType chartType = chartDef.getType();
        ChartCategories<?> categories = chartData.getCategories();
        ChartCategoryDataType categoryType = categories.getCategoryType();
        if (!StringUtils.isBlank((String)chartDef.getTitle())) {
            jw.beginObject("title");
            jw.write("text", chartDef.getTitle());
            jw.endObject();
        }
        if (!StringUtils.isBlank((String)chartDef.getSubTitle())) {
            jw.beginObject("subtitle");
            jw.write("text", chartDef.getSubTitle());
            jw.endObject();
        }
        jw.beginObject("chart");
        if (chartDef.getWidth() > 0) {
            jw.write("width", chartDef.getWidth());
        }
        if (chartDef.getHeight() > 0) {
            jw.write("height", chartDef.getHeight());
        }
        jw.write("type", chartType.optionsType());
        jw.write("stacked", chartDef.isStacked());
        jw.beginObject("toolbar");
        jw.write("show", false);
        jw.endObject();
        jw.beginObject("sparkline");
        jw.write("enabled", sparkLine);
        jw.endObject();
        jw.endObject();
        jw.beginObject("grid");
        jw.write("show", chartDef.isShowGrid());
        jw.endObject();
        jw.beginObject("stroke");
        if (chartDef.isSmooth()) {
            jw.write("curve", "smooth");
        } else {
            jw.write("curve", "straight");
        }
        jw.endObject();
        jw.beginObject("dataLabels");
        jw.write("enabled", chartDef.isShowDataLabels());
        jw.endObject();
        jw.beginObject("theme");
        jw.write("mode", "light");
        jw.write("palette", chartDef.getPaletteType().optionsType());
        jw.endObject();
        if (chartType.plotOptions()) {
            jw.beginObject("plotOptions");
            if (chartType.axisChart()) {
                jw.beginObject("bar");
                jw.write("horizontal", ChartType.BAR.equals((Object)chartType));
                jw.endObject();
            } else {
                jw.beginObject("pie");
                jw.write("customScale", 0.8);
                if (ChartType.DONUT.equals((Object)chartType)) {
                    jw.beginObject("donut");
                    jw.write("size", "75%");
                    jw.endObject();
                }
                jw.endObject();
            }
            jw.endObject();
        }
        if (chartType.axisChart()) {
            jw.beginArray("series");
            for (ChartSeries<?> series : chartData.getSeries()) {
                jw.beginObject();
                jw.write("name", series.getName());
                switch (series.getSeriesType()) {
                    case DOUBLE: {
                        jw.write("data", ((DoubleChartSeries)series).dataToArray());
                        break;
                    }
                    case INTEGER: {
                        jw.write("data", ((IntegerChartSeries)series).dataToArray());
                        break;
                    }
                    case LONG: {
                        jw.write("data", ((LongChartSeries)series).dataToArray());
                        break;
                    }
                }
                jw.endObject();
            }
            jw.endArray();
            jw.beginObject("xaxis");
            jw.write("type", categoryType.optionsType());
            switch (categoryType) {
                case DATE: {
                    jw.write("categories", (Number[])DataUtils.convert(Long[].class, ((DateChartCategories)categories).categoriesToArray()));
                    break;
                }
                case INTEGER: {
                    jw.write("categories", (Number[])((IntegerChartCategories)categories).categoriesToArray());
                    break;
                }
                case LONG: {
                    jw.write("categories", (Number[])((LongChartCategories)categories).categoriesToArray());
                    break;
                }
                case STRING: {
                    jw.write("categories", (String[])((StringChartCategories)categories).categoriesToArray());
                    break;
                }
            }
            jw.endObject();
        } else {
            ChartSeries<?> series = chartData.getSeries().get(0);
            switch (series.getSeriesType()) {
                case DOUBLE: {
                    jw.write("series", ((DoubleChartSeries)series).dataToArray());
                    break;
                }
                case INTEGER: {
                    jw.write("series", ((IntegerChartSeries)series).dataToArray());
                    break;
                }
                case LONG: {
                    jw.write("series", ((LongChartSeries)series).dataToArray());
                    break;
                }
            }
            jw.write("labels", (String[])DataUtils.convert(String[].class, categories.categoriesToArray()));
            jw.beginObject("legend");
            jw.write("position", "left");
            jw.write("offsetY", 60);
            jw.endObject();
        }
        jw.endObject();
        return jw;
    }

    public static String getOptionsJson(ChartDef chartDef, ChartData chartData, boolean sparkLine) throws UnifyException {
        return ChartUtils.getOptionsJsonWriter(chartDef, chartData, sparkLine).toString();
    }
}

