/*
 * Copyright 2021-2022 FlowCentral Technologies Limited.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.flowcentraltech.flowcentral.chart.data;

import com.flowcentraltech.flowcentral.common.business.RuleListComponent;
import com.tcdng.unify.core.UnifyException;

/**
 * Chart data provider.
 * 
 * @author FlowCentral Technologies Limited
 * @since 1.0
 */
public interface ChartDataProvider extends RuleListComponent {

    /**
     * Provides data.
     * 
     * @param rule
     *             optional rule
     * @return the chart data
     * @throws UnifyException
     *                        if an error occurs
     */
    ChartData provide(String rule) throws UnifyException;
}
