/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.junit;

import com.fitbur.asm.ClassReader;
import com.fitbur.asm.ClassVisitor;
import com.fitbur.guava.common.base.Preconditions;
import com.fitbur.testify.TestContext;
import com.fitbur.testify.TestReifier;
import com.fitbur.testify.analyzer.CutClassAnalyzer;
import com.fitbur.testify.analyzer.TestClassAnalyzer;
import com.fitbur.testify.descriptor.CutDescriptor;
import com.fitbur.testify.junit.core.JUnitTestNotifier;
import com.fitbur.testify.unit.UnitTestCreator;
import com.fitbur.testify.unit.UnitTestReifier;
import com.fitbur.testify.unit.UnitTestVerifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class UnitTest
extends BlockJUnit4ClassRunner {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"testify");
    Map<Class, TestContext> testClassContexts = new ConcurrentHashMap<Class, TestContext>();

    public UnitTest(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    public TestContext getTestContext(Class<?> clazz) {
        String string = clazz.getSimpleName();
        TestContext testContext = this.testClassContexts.computeIfAbsent(clazz, clazz2 -> {
            try {
                TestContext testContext = new TestContext(string, clazz, LOGGER);
                ClassReader classReader = new ClassReader(clazz.getName());
                classReader.accept((ClassVisitor)new TestClassAnalyzer(testContext), 2);
                CutDescriptor cutDescriptor = testContext.getCutDescriptor();
                if (cutDescriptor != null) {
                    ClassReader classReader2 = new ClassReader(cutDescriptor.getType().getName());
                    classReader2.accept((ClassVisitor)new CutClassAnalyzer(testContext), 2);
                }
                return testContext;
            }
            catch (Exception exception) {
                Preconditions.checkState((boolean)false, (String)"Analysis of test class '%s' failed.\n'%s'", (Object[])new Object[]{string, exception.getMessage()});
                throw new IllegalStateException(exception);
            }
        });
        return testContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier runNotifier) {
        Description description = this.getDescription();
        TestClass testClass = this.getTestClass();
        Class clazz = testClass.getJavaClass();
        TestContext testContext = this.getTestContext(clazz);
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
        JUnitTestNotifier jUnitTestNotifier = new JUnitTestNotifier(runNotifier, description, LOGGER, testContext);
        try {
            Statement statement = this.classBlock((RunNotifier)jUnitTestNotifier);
            statement.evaluate();
        }
        catch (AssumptionViolatedException assumptionViolatedException) {
            jUnitTestNotifier.addFailedAssumption(assumptionViolatedException);
        }
        catch (StoppedByUserException stoppedByUserException) {
            throw stoppedByUserException;
        }
        catch (IllegalStateException illegalStateException) {
            jUnitTestNotifier.addFailure((Throwable)illegalStateException);
            jUnitTestNotifier.pleaseStop();
        }
        catch (Throwable throwable) {
            jUnitTestNotifier.addFailure(throwable);
            jUnitTestNotifier.pleaseStop();
        }
        finally {
            if (SLF4JBridgeHandler.isInstalled()) {
                SLF4JBridgeHandler.uninstall();
            }
        }
    }

    protected Statement classBlock(RunNotifier runNotifier) {
        TestClass testClass = this.getTestClass();
        Class clazz = testClass.getJavaClass();
        TestContext testContext = this.getTestContext(clazz);
        UnitTestVerifier unitTestVerifier = new UnitTestVerifier(testContext, LOGGER);
        unitTestVerifier.dependency();
        unitTestVerifier.configuration();
        return super.classBlock(runNotifier);
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        TestClass testClass = this.getTestClass();
        Class clazz = testClass.getJavaClass();
        try {
            Object object = this.createTest();
            TestContext testContext = this.getTestContext(clazz);
            testContext.setTestInstance(object);
            UnitTestReifier unitTestReifier = new UnitTestReifier(object);
            UnitTestCreator unitTestCreator = new UnitTestCreator(testContext, (TestReifier)unitTestReifier);
            unitTestCreator.create();
            UnitTestVerifier unitTestVerifier = new UnitTestVerifier(testContext, LOGGER);
            unitTestVerifier.wiring();
            Statement statement = this.methodInvoker(frameworkMethod, object);
            statement = this.possiblyExpectingExceptions(frameworkMethod, object, statement);
            statement = this.withBefores(frameworkMethod, object, statement);
            statement = this.withAfters(frameworkMethod, object, statement);
            statement = this.withRules(frameworkMethod, object, statement);
            return statement;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private Statement withRules(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        List list = this.getTestRules(object);
        Statement statement2 = statement;
        statement2 = this.withMethodRules(frameworkMethod, list, object, statement2);
        statement2 = this.withTestRules(frameworkMethod, list, statement2);
        return statement2;
    }

    private Statement withMethodRules(FrameworkMethod frameworkMethod, List<TestRule> list, Object object, Statement statement) {
        for (MethodRule methodRule : this.getMethodRules(object)) {
            if (list.contains(methodRule)) continue;
            statement = methodRule.apply(statement, frameworkMethod, object);
        }
        return statement;
    }

    private List<MethodRule> getMethodRules(Object object) {
        return this.rules(object);
    }

    private Statement withTestRules(FrameworkMethod frameworkMethod, List<TestRule> list, Statement statement) {
        return list.isEmpty() ? statement : new RunRules(statement, list, this.describeChild(frameworkMethod));
    }
}

