/*
 * Decompiled with CFR 0.152.
 */
package com.fit2cloud.quartz.config;

import com.fit2cloud.quartz.config.FixedDelayJobData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.listeners.JobListenerSupport;

public final class FixedDelayJobListener
extends JobListenerSupport {
    private static final String FIXED_JOB_LISTENER_NAME = "FixedDelayJobListener";
    public static final String FIXED_DELAY_JOB_DATA = "FIXED_DELAY_JOB_DATA";

    public String getName() {
        return FIXED_JOB_LISTENER_NAME;
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
        JobDetail jobdetail = context.getJobDetail();
        JobDataMap data = jobdetail.getJobDataMap();
        if (!data.containsKey((Object)FIXED_DELAY_JOB_DATA)) {
            this.getLog().debug("Not a fixed delay job : {}", (Object)context.getJobDetail().getKey());
            return;
        }
        if (this.shouldNotSchedule(context)) {
            this.getLog().debug("Not scheduling {} again as there is still an unfired trigger.", (Object)context.getJobDetail().getKey());
            return;
        }
        this.getLog().debug("Rescheduling {} as there is no unfired trigger.", (Object)context.getJobDetail().getKey());
        TriggerKey oldTriggerKey = context.getTrigger().getKey();
        FixedDelayJobData jobData = (FixedDelayJobData)data.getWrappedMap().get(FIXED_DELAY_JOB_DATA);
        Trigger newTrigger = this.buildNewTrigger(jobData, oldTriggerKey);
        this.rescheduleJob(context.getScheduler(), oldTriggerKey, newTrigger);
    }

    private boolean shouldNotSchedule(JobExecutionContext context) {
        List<? extends Trigger> triggersOfJob = this.getTriggersOfJob(context);
        for (Trigger trigger : triggersOfJob) {
            if (!(trigger instanceof SimpleTrigger) || ((SimpleTrigger)trigger).getTimesTriggered() != 0) continue;
            return true;
        }
        return false;
    }

    private List<? extends Trigger> getTriggersOfJob(JobExecutionContext context) {
        List triggersOfJob = new ArrayList();
        try {
            triggersOfJob = context.getScheduler().getTriggersOfJob(context.getJobDetail().getKey());
        }
        catch (SchedulerException e) {
            this.getLog().error(e.getMessage());
        }
        return triggersOfJob;
    }

    private Trigger buildNewTrigger(FixedDelayJobData jobData, TriggerKey oldTriggerKey) {
        Date runTime = jobData.getNextScheduleDate();
        Trigger newTrigger = TriggerBuilder.newTrigger().withIdentity(oldTriggerKey).startAt(runTime).build();
        return newTrigger;
    }

    public void rescheduleJob(Scheduler scheduler, TriggerKey oldTriggerKey, Trigger newTrigger) {
        try {
            if (!scheduler.isShutdown()) {
                scheduler.rescheduleJob(oldTriggerKey, newTrigger);
            }
        }
        catch (SchedulerException se) {
            this.getLog().error("failed to reschedule the job with triger : {}", (Object)oldTriggerKey, (Object)se);
        }
    }
}

