/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.twitter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.firebase.ui.auth.core.FirebaseResponse;
import com.firebase.ui.auth.twitter.TwitterActions;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterPromptActivity
extends Activity {
    private static final String TAG = TwitterPromptActivity.class.getSimpleName();
    private Twitter mTwitter;
    private WebView mTwitterView;

    public void onBackPressed() {
        this.sendResultError(TwitterActions.USER_ERROR, FirebaseResponse.LOGIN_CANCELLED.ordinal(), "User closed login prompt.");
        super.onBackPressed();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String twitterKey = "";
        String twitterSecret = "";
        try {
            ApplicationInfo ai = this.getPackageManager().getApplicationInfo(this.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            twitterKey = bundle.getString("com.firebase.ui.TwitterKey");
            twitterSecret = bundle.getString("com.firebase.ui.TwitterSecret");
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (twitterKey == null || twitterSecret == null) {
            this.sendResultError(TwitterActions.PROVIDER_ERROR, FirebaseResponse.MISSING_PROVIDER_APP_KEY.ordinal(), "Missing Twitter key/secret, are they set in your AndroidManifest.xml?");
            return;
        }
        if (twitterKey.compareTo("") == 0 || twitterSecret.compareTo("") == 0) {
            this.sendResultError(TwitterActions.PROVIDER_ERROR, FirebaseResponse.INVALID_PROVIDER_APP_KEY.ordinal(), "Invalid Twitter key/secret, are they set in your res/values/strings.xml?");
            return;
        }
        this.mTwitter = new TwitterFactory(new ConfigurationBuilder().setOAuthConsumerKey(twitterKey).setOAuthConsumerSecret(twitterSecret).build()).getInstance();
        this.mTwitterView = new WebView((Context)this);
        this.mTwitterView.getSettings().setJavaScriptEnabled(true);
        this.setContentView((View)this.mTwitterView);
        new AsyncTask<Void, Void, RequestToken>(){

            protected RequestToken doInBackground(Void ... params) {
                RequestToken token = null;
                try {
                    token = TwitterPromptActivity.this.mTwitter.getOAuthRequestToken("oauth://cb");
                }
                catch (TwitterException te) {
                    TwitterPromptActivity.this.sendResultError(TwitterActions.PROVIDER_ERROR, FirebaseResponse.MISC_PROVIDER_ERROR.ordinal(), te.toString());
                }
                return token;
            }

            protected void onPostExecute(final RequestToken token) {
                if (token == null) {
                    return;
                }
                TwitterPromptActivity.this.mTwitterView.setWebViewClient(new WebViewClient(){

                    public void onPageFinished(WebView view, String url) {
                        if (url.startsWith("oauth://cb")) {
                            TwitterPromptActivity.this.mTwitterView.destroy();
                            if (url.contains("oauth_verifier")) {
                                TwitterPromptActivity.this.getTwitterOAuthTokenAndLogin(token, Uri.parse((String)url).getQueryParameter("oauth_verifier"));
                            } else if (url.contains("denied")) {
                                TwitterPromptActivity.this.sendResultError(TwitterActions.USER_ERROR, FirebaseResponse.LOGIN_CANCELLED.ordinal(), "User denied access to their account.");
                            }
                        }
                    }
                });
                TwitterPromptActivity.this.mTwitterView.loadUrl(token.getAuthorizationURL());
            }
        }.execute((Object[])new Void[0]);
    }

    private void getTwitterOAuthTokenAndLogin(final RequestToken requestToken, final String oauthVerifier) {
        new AsyncTask<Void, Void, AccessToken>(){

            protected AccessToken doInBackground(Void ... params) {
                AccessToken accessToken = null;
                try {
                    accessToken = TwitterPromptActivity.this.mTwitter.getOAuthAccessToken(requestToken, oauthVerifier);
                }
                catch (TwitterException te) {
                    TwitterPromptActivity.this.sendResultError(TwitterActions.PROVIDER_ERROR, FirebaseResponse.MISC_PROVIDER_ERROR.ordinal(), te.toString());
                }
                return accessToken;
            }

            protected void onPostExecute(AccessToken token) {
                Intent resultIntent = new Intent();
                resultIntent.putExtra("oauth_token", token.getToken());
                resultIntent.putExtra("oauth_token_secret", token.getTokenSecret());
                resultIntent.putExtra("user_id", token.getUserId() + "");
                TwitterPromptActivity.this.setResult(TwitterActions.SUCCESS, resultIntent);
                TwitterPromptActivity.this.finish();
            }
        }.execute((Object[])new Void[0]);
    }

    private void sendResultError(Integer status, int errCode, String err) {
        Intent resultIntent = new Intent();
        resultIntent.putExtra("error", err);
        resultIntent.putExtra("code", errCode);
        this.setResult(status, resultIntent);
        this.finish();
    }
}

