/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.core;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import com.firebase.client.AuthData;
import com.firebase.client.Firebase;
import com.firebase.ui.R;
import com.firebase.ui.auth.core.AuthProviderType;
import com.firebase.ui.auth.core.FirebaseAuthProvider;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.TokenAuthHandler;
import com.firebase.ui.auth.google.GoogleAuthProvider;
import java.util.HashMap;
import java.util.Map;

public class FirebaseLoginDialog
extends DialogFragment {
    Map<AuthProviderType, FirebaseAuthProvider> mEnabledProvidersByType = new HashMap<AuthProviderType, FirebaseAuthProvider>();
    TokenAuthHandler mHandler;
    AuthProviderType mActiveProvider;
    Firebase mRef;
    Context mContext;
    View mView;

    public void onStop() {
        super.onStop();
        this.cleanUp();
    }

    public void onDestroy() {
        super.onDestroy();
        this.cleanUp();
    }

    public void onPause() {
        super.onPause();
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.getGoogleAuthProvider() != null) {
            this.getGoogleAuthProvider().cleanUp();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        for (FirebaseAuthProvider provider : this.mEnabledProvidersByType.values()) {
            provider.onActivityResult(requestCode, resultCode, data);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        this.mView = inflater.inflate(R.layout.fragment_firebase_login, null);
        for (AuthProviderType providerType : AuthProviderType.values()) {
            if (this.mEnabledProvidersByType.keySet().contains((Object)providerType)) {
                this.showLoginOption(this.mEnabledProvidersByType.get((Object)providerType), providerType.getButtonId());
                continue;
            }
            this.mView.findViewById(providerType.getButtonId()).setVisibility(8);
        }
        if (this.mEnabledProvidersByType.containsKey((Object)AuthProviderType.PASSWORD) && !this.mEnabledProvidersByType.containsKey((Object)AuthProviderType.FACEBOOK) && !this.mEnabledProvidersByType.containsKey((Object)AuthProviderType.GOOGLE) && !this.mEnabledProvidersByType.containsKey((Object)AuthProviderType.TWITTER)) {
            this.mView.findViewById(R.id.or_section).setVisibility(8);
        }
        this.mView.findViewById(R.id.loading_section).setVisibility(8);
        builder.setView(this.mView);
        this.setRetainInstance(true);
        return builder.create();
    }

    public FirebaseLoginDialog setRef(Firebase ref) {
        this.mRef = ref;
        return this;
    }

    public FirebaseLoginDialog setContext(Context context) {
        this.mContext = context;
        return this;
    }

    public void reset() {
        this.mView.findViewById(R.id.login_section).setVisibility(0);
        this.mView.findViewById(R.id.loading_section).setVisibility(8);
    }

    public void logout() {
        for (FirebaseAuthProvider provider : this.mEnabledProvidersByType.values()) {
            provider.logout();
        }
        this.mRef.unauth();
    }

    public FirebaseLoginDialog setHandler(final TokenAuthHandler handler) {
        this.mHandler = new TokenAuthHandler(){

            @Override
            public void onSuccess(AuthData auth) {
                FirebaseLoginDialog.this.dismiss();
                handler.onSuccess(auth);
            }

            @Override
            public void onUserError(FirebaseLoginError err) {
                handler.onUserError(err);
            }

            @Override
            public void onProviderError(FirebaseLoginError err) {
                handler.onProviderError(err);
            }
        };
        return this;
    }

    public FirebaseLoginDialog setEnabledProvider(AuthProviderType provider) {
        if (!this.mEnabledProvidersByType.containsKey((Object)provider)) {
            this.mEnabledProvidersByType.put(provider, provider.createProvider(this.mContext, this.mRef, this.mHandler));
        }
        return this;
    }

    private void showLoginOption(final FirebaseAuthProvider helper, int id2) {
        this.mView.findViewById(id2).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AuthProviderType.getTypeForProvider(helper) == AuthProviderType.PASSWORD) {
                    EditText emailText = (EditText)FirebaseLoginDialog.this.mView.findViewById(R.id.email);
                    EditText passwordText = (EditText)FirebaseLoginDialog.this.mView.findViewById(R.id.password);
                    helper.login(emailText.getText().toString(), passwordText.getText().toString());
                    passwordText.setText((CharSequence)"");
                } else {
                    helper.login();
                }
                FirebaseLoginDialog.this.mActiveProvider = helper.getProviderType();
                FirebaseLoginDialog.this.mView.findViewById(R.id.login_section).setVisibility(8);
                FirebaseLoginDialog.this.mView.findViewById(R.id.loading_section).setVisibility(0);
            }
        });
    }

    public GoogleAuthProvider getGoogleAuthProvider() {
        return (GoogleAuthProvider)this.mEnabledProvidersByType.get((Object)AuthProviderType.GOOGLE);
    }
}

