/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.password;

import android.app.Activity;
import android.content.Context;
import com.firebase.client.AuthData;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.ui.auth.core.FirebaseAuthProvider;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.FirebaseResponse;
import com.firebase.ui.auth.core.SocialProvider;
import com.firebase.ui.auth.core.TokenAuthHandler;

public class PasswordAuthProvider
extends FirebaseAuthProvider {
    private final String LOG_TAG = "PasswordAuthProvider";
    public static final String PROVIDER_NAME = "password";
    public static final SocialProvider PROVIDER_TYPE = SocialProvider.password;
    private TokenAuthHandler mHandler;
    private Activity mActivity;
    private Firebase mRef;

    public PasswordAuthProvider(Context context, Firebase ref, TokenAuthHandler handler) {
        this.mActivity = (Activity)context;
        this.mRef = ref;
        this.mHandler = handler;
    }

    @Override
    public void login(String email, String password) {
        this.mRef.authWithPassword(email, password, new Firebase.AuthResultHandler(){

            public void onAuthenticated(AuthData authData) {
                PasswordAuthProvider.this.mHandler.onSuccess(authData);
            }

            public void onAuthenticationError(FirebaseError firebaseError) {
                PasswordAuthProvider.this.mHandler.onUserError(new FirebaseLoginError(FirebaseResponse.MISC_PROVIDER_ERROR, firebaseError.toString()));
            }
        });
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public Firebase getFirebaseRef() {
        return this.mRef;
    }

    @Override
    public SocialProvider getProviderType() {
        return PROVIDER_TYPE;
    }

    @Override
    public void logout() {
    }
}

