/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.firebase.client.Firebase;
import com.firebase.client.Query;
import com.firebase.ui.FirebaseArray;

public abstract class FirebaseListAdapter<T>
extends BaseAdapter {
    private final Class<T> mModelClass;
    protected int mLayout;
    protected Activity mActivity;
    FirebaseArray mSnapshots;

    public FirebaseListAdapter(Activity activity, Class<T> modelClass, int modelLayout, Query ref) {
        this.mModelClass = modelClass;
        this.mLayout = modelLayout;
        this.mActivity = activity;
        this.mSnapshots = new FirebaseArray(ref);
        this.mSnapshots.setOnChangedListener(new FirebaseArray.OnChangedListener(){

            @Override
            public void onChanged(FirebaseArray.OnChangedListener.EventType type, int index, int oldIndex) {
                FirebaseListAdapter.this.notifyDataSetChanged();
            }
        });
    }

    public FirebaseListAdapter(Activity activity, Class<T> modelClass, int modelLayout, Firebase ref) {
        this(activity, modelClass, modelLayout, (Query)ref);
    }

    public void cleanup() {
        this.mSnapshots.cleanup();
    }

    public int getCount() {
        return this.mSnapshots.getCount();
    }

    public T getItem(int i) {
        return (T)this.mSnapshots.getItem(i).getValue(this.mModelClass);
    }

    public Firebase getRef(int position) {
        return this.mSnapshots.getItem(position).getRef();
    }

    public long getItemId(int i) {
        return this.mSnapshots.getItem(i).getKey().hashCode();
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        if (view == null) {
            view = this.mActivity.getLayoutInflater().inflate(this.mLayout, viewGroup, false);
        }
        Object model = this.mSnapshots.getItem(i).getValue(this.mModelClass);
        this.populateView(view, model);
        return view;
    }

    protected abstract void populateView(View var1, T var2);
}

