/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.database.paging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.paging.PagingData;
import androidx.paging.PagingDataAdapter;
import androidx.recyclerview.widget.RecyclerView;
import com.firebase.ui.database.SnapshotParser;
import com.firebase.ui.database.paging.DatabasePagingOptions;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseReference;

public abstract class FirebaseRecyclerPagingAdapter<T, VH extends RecyclerView.ViewHolder>
extends PagingDataAdapter<DataSnapshot, VH>
implements LifecycleObserver {
    private DatabasePagingOptions<T> mOptions;
    private SnapshotParser<T> mParser;
    private LiveData<PagingData<DataSnapshot>> mPagingData;
    private final Observer<PagingData<DataSnapshot>> mDataObserver = new Observer<PagingData<DataSnapshot>>(){

        public void onChanged(@Nullable PagingData<DataSnapshot> snapshots) {
            if (snapshots == null) {
                return;
            }
            FirebaseRecyclerPagingAdapter.this.submitData(FirebaseRecyclerPagingAdapter.this.mOptions.getOwner().getLifecycle(), snapshots);
        }
    };

    public FirebaseRecyclerPagingAdapter(@NonNull DatabasePagingOptions<T> options) {
        super(options.getDiffCallback());
        this.mOptions = options;
        this.init();
    }

    public void init() {
        this.mPagingData = this.mOptions.getData();
        this.mParser = this.mOptions.getParser();
        if (this.mOptions.getOwner() != null) {
            this.mOptions.getOwner().getLifecycle().addObserver((LifecycleObserver)this);
        }
    }

    public void updateOptions(@NonNull DatabasePagingOptions<T> options) {
        this.mOptions = options;
        boolean hasObservers = this.mPagingData.hasObservers();
        if (this.mOptions.getOwner() != null) {
            this.mOptions.getOwner().getLifecycle().removeObserver((LifecycleObserver)this);
        }
        this.stopListening();
        this.init();
        if (hasObservers) {
            this.startListening();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void startListening() {
        this.mPagingData.observeForever(this.mDataObserver);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void stopListening() {
        this.mPagingData.removeObserver(this.mDataObserver);
    }

    public void onBindViewHolder(@NonNull VH viewHolder, int position) {
        DataSnapshot snapshot = (DataSnapshot)this.getItem(position);
        this.onBindViewHolder(viewHolder, position, this.mParser.parseSnapshot(snapshot));
    }

    protected abstract void onBindViewHolder(@NonNull VH var1, int var2, @NonNull T var3);

    @NonNull
    public DatabaseReference getRef(int position) {
        return ((DataSnapshot)this.getItem(position)).getRef();
    }
}

