/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.database.paging;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.DiffUtil;
import com.firebase.ui.database.SnapshotParser;
import com.google.firebase.database.DataSnapshot;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DefaultSnapshotDiffCallback<T>
extends DiffUtil.ItemCallback<DataSnapshot> {
    private final SnapshotParser<T> mParser;

    public DefaultSnapshotDiffCallback(@NonNull SnapshotParser<T> parser) {
        this.mParser = parser;
    }

    public boolean areItemsTheSame(@NonNull DataSnapshot oldItem, @NonNull DataSnapshot newItem) {
        return oldItem.getKey().equals(newItem.getKey());
    }

    @SuppressLint(value={"DiffUtilEquals"})
    public boolean areContentsTheSame(@NonNull DataSnapshot oldItem, @NonNull DataSnapshot newItem) {
        Object oldModel = this.mParser.parseSnapshot(oldItem);
        Object newModel = this.mParser.parseSnapshot(newItem);
        return oldModel.equals(newModel);
    }
}

