/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.database.paging;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import androidx.paging.rxjava3.RxPagingSource;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.Query;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nullable;

public class DatabasePagingSource
extends RxPagingSource<String, DataSnapshot> {
    private final Query mQuery;
    private static final String STATUS_DATABASE_NOT_FOUND = "DATA_NOT_FOUND";
    private static final String MESSAGE_DATABASE_NOT_FOUND = "Data not found at given child path!";
    private static final String DETAILS_DATABASE_NOT_FOUND = "No data was returned for the given query: ";

    public DatabasePagingSource(Query query) {
        this.mQuery = query;
    }

    @SuppressLint(value={"RestrictedApi"})
    @NonNull
    public Single<PagingSource.LoadResult<String, DataSnapshot>> loadSingle(@NonNull PagingSource.LoadParams<String> params) {
        Task task = params.getKey() == null ? this.mQuery.limitToFirst(params.getLoadSize()).get() : this.mQuery.startAt(null, (String)params.getKey()).limitToFirst(params.getLoadSize() + 1).get();
        return Single.fromCallable(() -> {
            try {
                Tasks.await((Task)task);
                DataSnapshot dataSnapshot = (DataSnapshot)task.getResult();
                if (dataSnapshot.exists()) {
                    ArrayList<DataSnapshot> data = new ArrayList<DataSnapshot>();
                    String lastKey = null;
                    if (params.getKey() == null) {
                        for (DataSnapshot snapshot : dataSnapshot.getChildren()) {
                            data.add(snapshot);
                        }
                    } else {
                        Iterator iterator = dataSnapshot.getChildren().iterator();
                        if (iterator.hasNext()) {
                            iterator.next();
                        }
                        while (iterator.hasNext()) {
                            DataSnapshot snapshot = (DataSnapshot)iterator.next();
                            data.add(snapshot);
                        }
                    }
                    if (!data.isEmpty()) {
                        lastKey = this.getLastPageKey(data);
                    }
                    return this.toLoadResult(data, lastKey);
                }
                String details = DETAILS_DATABASE_NOT_FOUND + this.mQuery.toString();
                throw DatabaseError.fromStatus((String)STATUS_DATABASE_NOT_FOUND, (String)MESSAGE_DATABASE_NOT_FOUND, (String)details).toException();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new Exception(e);
            }
        }).subscribeOn(Schedulers.io()).onErrorReturn(PagingSource.LoadResult.Error::new);
    }

    private PagingSource.LoadResult<String, DataSnapshot> toLoadResult(@NonNull List<DataSnapshot> snapshots, String nextPage) {
        return new PagingSource.LoadResult.Page(snapshots, null, (Object)nextPage, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Nullable
    private String getLastPageKey(@NonNull List<DataSnapshot> data) {
        if (data.isEmpty()) {
            return null;
        }
        return data.get(data.size() - 1).getKey();
    }

    @Nullable
    public String getRefreshKey(@NonNull PagingState<String, DataSnapshot> state) {
        return null;
    }
}

