/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.database.paging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.paging.Pager;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingLiveData;
import androidx.recyclerview.widget.DiffUtil;
import com.firebase.ui.database.ClassSnapshotParser;
import com.firebase.ui.database.SnapshotParser;
import com.firebase.ui.database.paging.DatabasePagingSource;
import com.firebase.ui.database.paging.DefaultSnapshotDiffCallback;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.Query;
import com.google.firebase.database.annotations.NotNull;

public final class DatabasePagingOptions<T> {
    private final SnapshotParser<T> mParser;
    private final LiveData<PagingData<DataSnapshot>> mData;
    private final DiffUtil.ItemCallback<DataSnapshot> mDiffCallback;
    private final LifecycleOwner mOwner;

    private DatabasePagingOptions(@NonNull LiveData<PagingData<DataSnapshot>> data, @NonNull SnapshotParser<T> parser, @NonNull DiffUtil.ItemCallback<DataSnapshot> diffCallback, @Nullable LifecycleOwner owner) {
        this.mParser = parser;
        this.mData = data;
        this.mDiffCallback = diffCallback;
        this.mOwner = owner;
    }

    @NonNull
    public LiveData<PagingData<DataSnapshot>> getData() {
        return this.mData;
    }

    @NonNull
    public SnapshotParser<T> getParser() {
        return this.mParser;
    }

    @NonNull
    public DiffUtil.ItemCallback<DataSnapshot> getDiffCallback() {
        return this.mDiffCallback;
    }

    @Nullable
    public LifecycleOwner getOwner() {
        return this.mOwner;
    }

    public static final class Builder<T> {
        private LiveData<PagingData<DataSnapshot>> mData;
        private SnapshotParser<T> mParser;
        private LifecycleOwner mOwner;
        private DiffUtil.ItemCallback<DataSnapshot> mDiffCallback;

        @NonNull
        public Builder<T> setQuery(@NonNull Query query, @NonNull PagingConfig config, @NonNull Class<T> modelClass) {
            return this.setQuery(query, config, new ClassSnapshotParser<T>(modelClass));
        }

        @NonNull
        public Builder<T> setQuery(@NonNull Query query, @NonNull PagingConfig config, @NotNull SnapshotParser<T> parser) {
            Pager pager = new Pager(config, () -> new DatabasePagingSource(query));
            this.mData = PagingLiveData.cachedIn((LiveData)PagingLiveData.getLiveData((Pager)pager), (Lifecycle)this.mOwner.getLifecycle());
            this.mParser = parser;
            return this;
        }

        @NonNull
        public Builder<T> setDiffCallback(@NonNull DiffUtil.ItemCallback<DataSnapshot> diffCallback) {
            this.mDiffCallback = diffCallback;
            return this;
        }

        @NonNull
        public Builder<T> setLifecycleOwner(@NonNull LifecycleOwner owner) {
            this.mOwner = owner;
            return this;
        }

        @NonNull
        public DatabasePagingOptions<T> build() {
            if (this.mData == null) {
                throw new IllegalStateException("Must call setQuery() before calling build().");
            }
            if (this.mDiffCallback == null) {
                this.mDiffCallback = new DefaultSnapshotDiffCallback<T>(this.mParser);
            }
            return new DatabasePagingOptions(this.mData, this.mParser, this.mDiffCallback, this.mOwner);
        }
    }
}

