/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.database;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.recyclerview.widget.RecyclerView;
import com.firebase.ui.common.ChangeEventType;
import com.firebase.ui.database.FirebaseAdapter;
import com.firebase.ui.database.FirebaseRecyclerOptions;
import com.firebase.ui.database.ObservableSnapshotArray;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;

public abstract class FirebaseRecyclerAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements FirebaseAdapter<T> {
    private static final String TAG = "FirebaseRecyclerAdapter";
    private FirebaseRecyclerOptions<T> mOptions;
    private ObservableSnapshotArray<T> mSnapshots;

    public FirebaseRecyclerAdapter(@NonNull FirebaseRecyclerOptions<T> options) {
        this.mOptions = options;
        this.mSnapshots = options.getSnapshots();
        if (this.mOptions.getOwner() != null) {
            this.mOptions.getOwner().getLifecycle().addObserver((LifecycleObserver)this);
        }
    }

    @Override
    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void startListening() {
        if (!this.mSnapshots.isListening(this)) {
            this.mSnapshots.addChangeEventListener(this);
        }
    }

    @Override
    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void stopListening() {
        this.mSnapshots.removeChangeEventListener(this);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    void cleanup(LifecycleOwner source) {
        source.getLifecycle().removeObserver((LifecycleObserver)this);
    }

    public void onChildChanged(@NonNull ChangeEventType type, @NonNull DataSnapshot snapshot, int newIndex, int oldIndex) {
        switch (type) {
            case ADDED: {
                this.notifyItemInserted(newIndex);
                break;
            }
            case CHANGED: {
                this.notifyItemChanged(newIndex);
                break;
            }
            case REMOVED: {
                this.notifyItemRemoved(newIndex);
                break;
            }
            case MOVED: {
                this.notifyItemMoved(oldIndex, newIndex);
                break;
            }
            default: {
                throw new IllegalStateException("Incomplete case statement");
            }
        }
    }

    public void onDataChanged() {
    }

    public void onError(@NonNull DatabaseError error) {
        Log.w((String)TAG, (Throwable)error.toException());
    }

    @Override
    @NonNull
    public ObservableSnapshotArray<T> getSnapshots() {
        return this.mSnapshots;
    }

    @Override
    @NonNull
    public T getItem(int position) {
        return (T)this.mSnapshots.get(position);
    }

    @Override
    @NonNull
    public DatabaseReference getRef(int position) {
        return ((DataSnapshot)this.mSnapshots.getSnapshot(position)).getRef();
    }

    public int getItemCount() {
        return this.mSnapshots.isListening(this) ? this.mSnapshots.size() : 0;
    }

    public void updateOptions(@NonNull FirebaseRecyclerOptions<T> options) {
        boolean wasListening = this.mSnapshots.isListening(this);
        if (this.mOptions.getOwner() != null) {
            this.mOptions.getOwner().getLifecycle().removeObserver((LifecycleObserver)this);
        }
        this.mSnapshots.clear();
        this.stopListening();
        this.mOptions = options;
        this.mSnapshots = options.getSnapshots();
        if (options.getOwner() != null) {
            options.getOwner().getLifecycle().addObserver((LifecycleObserver)this);
        }
        if (wasListening) {
            this.startListening();
        }
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        this.onBindViewHolder(holder, position, this.getItem(position));
    }

    protected abstract void onBindViewHolder(@NonNull VH var1, int var2, @NonNull T var3);
}

