/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.database;

import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import com.firebase.ui.common.Preconditions;
import com.firebase.ui.database.ClassSnapshotParser;
import com.firebase.ui.database.FirebaseArray;
import com.firebase.ui.database.FirebaseIndexArray;
import com.firebase.ui.database.ObservableSnapshotArray;
import com.firebase.ui.database.SnapshotParser;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Query;

public final class FirebaseListOptions<T> {
    private static final String ERR_SNAPSHOTS_SET = "Snapshot array already set. Call only one of setSnapshotArray, setQuery, or setIndexedQuery.";
    private final ObservableSnapshotArray<T> mSnapshots;
    @LayoutRes
    private final int mLayout;
    private final LifecycleOwner mOwner;

    private FirebaseListOptions(ObservableSnapshotArray<T> snapshots, @LayoutRes int layout, LifecycleOwner owner) {
        this.mSnapshots = snapshots;
        this.mLayout = layout;
        this.mOwner = owner;
    }

    @NonNull
    public ObservableSnapshotArray<T> getSnapshots() {
        return this.mSnapshots;
    }

    @LayoutRes
    public int getLayout() {
        return this.mLayout;
    }

    @Nullable
    public LifecycleOwner getOwner() {
        return this.mOwner;
    }

    public static final class Builder<T> {
        private ObservableSnapshotArray<T> mSnapshots;
        @LayoutRes
        private Integer mLayout;
        private LifecycleOwner mOwner;

        @NonNull
        public Builder<T> setSnapshotArray(@NonNull ObservableSnapshotArray<T> snapshots) {
            Preconditions.assertNull(this.mSnapshots, (String)FirebaseListOptions.ERR_SNAPSHOTS_SET);
            this.mSnapshots = snapshots;
            return this;
        }

        @NonNull
        public Builder<T> setQuery(@NonNull Query query, @NonNull SnapshotParser<T> parser) {
            Preconditions.assertNull(this.mSnapshots, (String)FirebaseListOptions.ERR_SNAPSHOTS_SET);
            this.mSnapshots = new FirebaseArray<T>(query, parser);
            return this;
        }

        @NonNull
        public Builder<T> setQuery(@NonNull Query query, @NonNull Class<T> modelClass) {
            return this.setQuery(query, new ClassSnapshotParser<T>(modelClass));
        }

        @NonNull
        public Builder<T> setIndexedQuery(@NonNull Query keyQuery, @NonNull DatabaseReference dataRef, @NonNull SnapshotParser<T> parser) {
            Preconditions.assertNull(this.mSnapshots, (String)FirebaseListOptions.ERR_SNAPSHOTS_SET);
            this.mSnapshots = new FirebaseIndexArray<T>(keyQuery, dataRef, parser);
            return this;
        }

        @NonNull
        public Builder<T> setIndexedQuery(@NonNull Query keyQuery, @NonNull DatabaseReference dataRef, @NonNull Class<T> modelClass) {
            return this.setIndexedQuery(keyQuery, dataRef, new ClassSnapshotParser<T>(modelClass));
        }

        @NonNull
        public Builder<T> setLayout(@LayoutRes int layout) {
            this.mLayout = layout;
            return this;
        }

        @NonNull
        public Builder<T> setLifecycleOwner(@Nullable LifecycleOwner owner) {
            this.mOwner = owner;
            return this;
        }

        @NonNull
        public FirebaseListOptions<T> build() {
            Preconditions.assertNonNull(this.mSnapshots, (String)"Snapshot array cannot be null. Call setQuery or setSnapshotArray.");
            Preconditions.assertNonNull((Object)this.mLayout, (String)"Layout cannot be null. Call setLayout.");
            return new FirebaseListOptions(this.mSnapshots, this.mLayout, this.mOwner);
        }
    }
}

