/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.database;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.firebase.ui.common.ChangeEventType;
import com.firebase.ui.database.FirebaseAdapter;
import com.firebase.ui.database.FirebaseListOptions;
import com.firebase.ui.database.ObservableSnapshotArray;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;

public abstract class FirebaseListAdapter<T>
extends BaseAdapter
implements FirebaseAdapter<T> {
    private static final String TAG = "FirebaseListAdapter";
    private final ObservableSnapshotArray<T> mSnapshots;
    protected final int mLayout;

    public FirebaseListAdapter(@NonNull FirebaseListOptions<T> options) {
        this.mSnapshots = options.getSnapshots();
        this.mLayout = options.getLayout();
        if (options.getOwner() != null) {
            options.getOwner().getLifecycle().addObserver((LifecycleObserver)this);
        }
    }

    @Override
    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void startListening() {
        if (!this.mSnapshots.isListening(this)) {
            this.mSnapshots.addChangeEventListener(this);
        }
    }

    @Override
    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void stopListening() {
        this.mSnapshots.removeChangeEventListener(this);
        this.notifyDataSetChanged();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    void cleanup(LifecycleOwner source) {
        source.getLifecycle().removeObserver((LifecycleObserver)this);
    }

    public void onChildChanged(@NonNull ChangeEventType type, @NonNull DataSnapshot snapshot, int newIndex, int oldIndex) {
        this.notifyDataSetChanged();
    }

    public void onDataChanged() {
    }

    public void onError(@NonNull DatabaseError error) {
        Log.w((String)TAG, (Throwable)error.toException());
    }

    @Override
    @NonNull
    public ObservableSnapshotArray<T> getSnapshots() {
        return this.mSnapshots;
    }

    @Override
    @NonNull
    public T getItem(int position) {
        return (T)this.mSnapshots.get(position);
    }

    @Override
    @NonNull
    public DatabaseReference getRef(int position) {
        return ((DataSnapshot)this.mSnapshots.getSnapshot(position)).getRef();
    }

    public int getCount() {
        return this.mSnapshots.size();
    }

    public long getItemId(int i) {
        return ((DataSnapshot)this.mSnapshots.getSnapshot(i)).getKey().hashCode();
    }

    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(this.mLayout, parent, false);
        }
        T model = this.getItem(position);
        this.populateView(convertView, model, position);
        return convertView;
    }

    protected abstract void populateView(@NonNull View var1, @NonNull T var2, int var3);
}

