/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.database;

import android.util.Log;
import androidx.annotation.NonNull;
import com.firebase.ui.common.ChangeEventType;
import com.firebase.ui.database.ChangeEventListener;
import com.firebase.ui.database.FirebaseArray;
import com.firebase.ui.database.ObservableSnapshotArray;
import com.firebase.ui.database.SnapshotParser;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Query;
import com.google.firebase.database.ValueEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FirebaseIndexArray<T>
extends ObservableSnapshotArray<T>
implements ChangeEventListener {
    private static final String TAG = "FirebaseIndexArray";
    private DatabaseReference mDataRef;
    private final Map<DatabaseReference, ValueEventListener> mRefs = new HashMap<DatabaseReference, ValueEventListener>();
    private final FirebaseArray<String> mKeySnapshots;
    private final List<DataSnapshot> mDataSnapshots = new ArrayList<DataSnapshot>();
    private final List<String> mKeysWithPendingUpdate = new ArrayList<String>();
    private boolean mHasPendingMoveOrDelete;

    public FirebaseIndexArray(@NonNull Query keyQuery, @NonNull DatabaseReference dataRef, @NonNull SnapshotParser<T> parser) {
        super(parser);
        this.mDataRef = dataRef;
        this.mKeySnapshots = new FirebaseArray(keyQuery, snapshot -> snapshot.getKey());
    }

    protected void onCreate() {
        super.onCreate();
        this.mKeySnapshots.addChangeEventListener(this);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mKeySnapshots.removeChangeEventListener(this);
        for (DatabaseReference ref : this.mRefs.keySet()) {
            ref.removeEventListener(this.mRefs.get(ref));
        }
        this.mRefs.clear();
    }

    public void onChildChanged(@NonNull ChangeEventType type, @NonNull DataSnapshot snapshot, int newIndex, int oldIndex) {
        switch (type) {
            case ADDED: {
                this.onKeyAdded(snapshot, newIndex);
                break;
            }
            case MOVED: {
                this.onKeyMoved(snapshot, newIndex, oldIndex);
                break;
            }
            case CHANGED: {
                break;
            }
            case REMOVED: {
                this.onKeyRemoved(snapshot, newIndex);
            }
        }
    }

    public void onDataChanged() {
        if (this.mHasPendingMoveOrDelete || this.mKeySnapshots.isEmpty()) {
            this.notifyOnDataChanged();
            this.mHasPendingMoveOrDelete = false;
        }
    }

    public void onError(@NonNull DatabaseError error) {
        Log.e((String)TAG, (String)"A fatal error occurred retrieving the necessary keys to populate your adapter.");
    }

    @NonNull
    protected List<DataSnapshot> getSnapshots() {
        return this.mDataSnapshots;
    }

    private int returnOrFindIndexForKey(int index, String key) {
        int realIndex;
        if (this.isKeyAtIndex(key, index)) {
            realIndex = index;
        } else {
            String superKey;
            int dataCount = this.size();
            int dataIndex = 0;
            for (int keyIndex = 0; dataIndex < dataCount && keyIndex < this.mKeySnapshots.size() && !key.equals(superKey = (String)this.mKeySnapshots.get(keyIndex)); ++keyIndex) {
                if (!this.mDataSnapshots.get(dataIndex).getKey().equals(superKey)) continue;
                ++dataIndex;
            }
            realIndex = dataIndex;
        }
        return realIndex;
    }

    private boolean isKeyAtIndex(String key, int index) {
        return index >= 0 && index < this.size() && this.mDataSnapshots.get(index).getKey().equals(key);
    }

    private void onKeyAdded(DataSnapshot data, int newIndex) {
        String key = data.getKey();
        DatabaseReference ref = this.mDataRef.child(key);
        this.mKeysWithPendingUpdate.add(key);
        this.mRefs.put(ref, ref.addValueEventListener((ValueEventListener)new DataRefListener(newIndex)));
    }

    private void onKeyMoved(DataSnapshot data, int index, int oldIndex) {
        String key = data.getKey();
        if (this.isKeyAtIndex(key, oldIndex)) {
            DataSnapshot snapshot = this.mDataSnapshots.remove(oldIndex);
            int realIndex = this.returnOrFindIndexForKey(index, key);
            this.mHasPendingMoveOrDelete = true;
            this.mDataSnapshots.add(realIndex, snapshot);
            this.notifyOnChildChanged(ChangeEventType.MOVED, snapshot, realIndex, oldIndex);
        }
    }

    private void onKeyRemoved(DataSnapshot data, int index) {
        int realIndex;
        String key = data.getKey();
        ValueEventListener listener = this.mRefs.remove(this.mDataRef.getRef().child(key));
        if (listener != null) {
            this.mDataRef.child(key).removeEventListener(listener);
        }
        if (this.isKeyAtIndex(key, realIndex = this.returnOrFindIndexForKey(index, key))) {
            DataSnapshot snapshot = this.mDataSnapshots.remove(realIndex);
            this.mHasPendingMoveOrDelete = true;
            this.notifyOnChildChanged(ChangeEventType.REMOVED, snapshot, realIndex, -1);
        }
    }

    private final class DataRefListener
    implements ValueEventListener {
        private int currentIndex;

        public DataRefListener(int index) {
            this.currentIndex = index;
        }

        public void onDataChange(DataSnapshot snapshot) {
            String key = snapshot.getKey();
            int index = this.currentIndex = FirebaseIndexArray.this.returnOrFindIndexForKey(this.currentIndex, key);
            if (snapshot.getValue() != null) {
                if (FirebaseIndexArray.this.isKeyAtIndex(key, index)) {
                    FirebaseIndexArray.this.mDataSnapshots.set(index, snapshot);
                    FirebaseIndexArray.this.notifyOnChildChanged(ChangeEventType.CHANGED, snapshot, index, -1);
                } else {
                    FirebaseIndexArray.this.mDataSnapshots.add(index, snapshot);
                    FirebaseIndexArray.this.notifyOnChildChanged(ChangeEventType.ADDED, snapshot, index, -1);
                }
            } else if (FirebaseIndexArray.this.isKeyAtIndex(key, index)) {
                FirebaseIndexArray.this.mDataSnapshots.remove(index);
                FirebaseIndexArray.this.notifyOnChildChanged(ChangeEventType.REMOVED, snapshot, index, -1);
            } else {
                Log.w((String)FirebaseIndexArray.TAG, (String)("Key not found at ref: " + snapshot.getRef()));
            }
            FirebaseIndexArray.this.mKeysWithPendingUpdate.remove(key);
            if (FirebaseIndexArray.this.mKeysWithPendingUpdate.isEmpty()) {
                FirebaseIndexArray.this.notifyOnDataChanged();
            }
        }

        public void onCancelled(DatabaseError error) {
            FirebaseIndexArray.this.notifyOnError(error);
        }
    }
}

