/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.database;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.firebase.ui.common.ChangeEventType;
import com.firebase.ui.database.ObservableSnapshotArray;
import com.firebase.ui.database.SnapshotParser;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.Query;
import com.google.firebase.database.ValueEventListener;
import java.util.ArrayList;
import java.util.List;

public class FirebaseArray<T>
extends ObservableSnapshotArray<T>
implements ChildEventListener,
ValueEventListener {
    private Query mQuery;
    private final List<DataSnapshot> mSnapshots = new ArrayList<DataSnapshot>();

    public FirebaseArray(@NonNull Query query, @NonNull SnapshotParser<T> parser) {
        super(parser);
        this.mQuery = query;
    }

    protected void onCreate() {
        super.onCreate();
        this.mQuery.addChildEventListener((ChildEventListener)this);
        this.mQuery.addValueEventListener((ValueEventListener)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mQuery.removeEventListener((ValueEventListener)this);
        this.mQuery.removeEventListener((ChildEventListener)this);
    }

    public void onChildAdded(@NonNull DataSnapshot snapshot, @Nullable String previousChildKey) {
        int index = 0;
        if (previousChildKey != null) {
            index = this.getIndexForKey(previousChildKey) + 1;
        }
        this.mSnapshots.add(index, snapshot);
        this.notifyOnChildChanged(ChangeEventType.ADDED, snapshot, index, -1);
    }

    public void onChildChanged(@NonNull DataSnapshot snapshot, @Nullable String previousChildKey) {
        int index = this.getIndexForKey(snapshot.getKey());
        this.mSnapshots.set(index, snapshot);
        this.notifyOnChildChanged(ChangeEventType.CHANGED, snapshot, index, -1);
    }

    public void onChildRemoved(@NonNull DataSnapshot snapshot) {
        int index = this.getIndexForKey(snapshot.getKey());
        this.mSnapshots.remove(index);
        this.notifyOnChildChanged(ChangeEventType.REMOVED, snapshot, index, -1);
    }

    public void onChildMoved(@NonNull DataSnapshot snapshot, @Nullable String previousChildKey) {
        int oldIndex = this.getIndexForKey(snapshot.getKey());
        this.mSnapshots.remove(oldIndex);
        int newIndex = previousChildKey == null ? 0 : this.getIndexForKey(previousChildKey) + 1;
        this.mSnapshots.add(newIndex, snapshot);
        this.notifyOnChildChanged(ChangeEventType.MOVED, snapshot, newIndex, oldIndex);
    }

    public void onDataChange(@NonNull DataSnapshot snapshot) {
        this.notifyOnDataChanged();
    }

    public void onCancelled(@NonNull DatabaseError error) {
        this.notifyOnError(error);
    }

    private int getIndexForKey(@NonNull String key) {
        int index = 0;
        for (DataSnapshot snapshot : this.mSnapshots) {
            if (snapshot.getKey().equals(key)) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("Key not found");
    }

    @NonNull
    protected List<DataSnapshot> getSnapshots() {
        return this.mSnapshots;
    }
}

