/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.ui;

import android.annotation.SuppressLint;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.widget.EditText;
import androidx.annotation.RestrictTo;
import java.util.Collections;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class BucketedTextChangeListener
implements TextWatcher {
    private final EditText mEditText;
    private final ContentChangeCallback mCallback;
    private final String[] mPostFixes;
    private final String mPlaceHolder;
    private final int mExpectedContentLength;

    public BucketedTextChangeListener(EditText editText, int expectedContentLength, String placeHolder, ContentChangeCallback callback) {
        this.mEditText = editText;
        this.mExpectedContentLength = expectedContentLength;
        this.mPostFixes = BucketedTextChangeListener.generatePostfixArray(placeHolder, expectedContentLength);
        this.mCallback = callback;
        this.mPlaceHolder = placeHolder;
    }

    private static String[] generatePostfixArray(CharSequence repeatableChar, int length) {
        String[] ret = new String[length + 1];
        for (int i = 0; i <= length; ++i) {
            ret[i] = TextUtils.join((CharSequence)"", Collections.nCopies(i, repeatableChar));
        }
        return ret;
    }

    @SuppressLint(value={"SetTextI18n"})
    public void onTextChanged(CharSequence s, int ignoredParam1, int ignoredParam2, int ignoredParam3) {
        String numericContents = s.toString().replaceAll(" ", "").replaceAll(this.mPlaceHolder, "");
        int enteredContentLength = Math.min(numericContents.length(), this.mExpectedContentLength);
        String enteredContent = numericContents.substring(0, enteredContentLength);
        this.mEditText.removeTextChangedListener((TextWatcher)this);
        this.mEditText.setText((CharSequence)(enteredContent + this.mPostFixes[this.mExpectedContentLength - enteredContentLength]));
        this.mEditText.setSelection(enteredContentLength);
        this.mEditText.addTextChangedListener((TextWatcher)this);
        if (enteredContentLength == this.mExpectedContentLength && this.mCallback != null) {
            this.mCallback.whenComplete();
        } else if (this.mCallback != null) {
            this.mCallback.whileIncomplete();
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface ContentChangeCallback {
        public void whenComplete();

        public void whileIncomplete();
    }
}

