/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.gms.auth.api.credentials.Credentials;
import com.google.android.gms.auth.api.credentials.CredentialsClient;
import com.google.android.gms.auth.api.credentials.CredentialsOptions;
import com.google.android.gms.common.GoogleApiAvailability;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class GoogleApiUtils {
    private GoogleApiUtils() {
        throw new AssertionError((Object)"No instance for you!");
    }

    public static boolean isPlayServicesAvailable(@NonNull Context context) {
        return GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0;
    }

    @NonNull
    public static CredentialsClient getCredentialsClient(@NonNull Context context) {
        CredentialsOptions options = new CredentialsOptions.Builder().forceEnableSaveDialog().build();
        if (context instanceof Activity) {
            return Credentials.getClient((Activity)((Activity)context), (CredentialsOptions)options);
        }
        return Credentials.getClient((Context)context, (CredentialsOptions)options);
    }
}

