/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.firebase.auth.FirebaseUser;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CredentialUtils {
    private static final String TAG = "CredentialUtils";

    private CredentialUtils() {
        throw new AssertionError((Object)"No instance for you!");
    }

    @Nullable
    public static Credential buildCredential(@NonNull FirebaseUser user, @Nullable String password, @Nullable String accountType) {
        Uri profilePictureUri;
        String email = user.getEmail();
        String phone = user.getPhoneNumber();
        Uri uri = profilePictureUri = user.getPhotoUrl() == null ? null : Uri.parse((String)user.getPhotoUrl().toString());
        if (TextUtils.isEmpty((CharSequence)email) && TextUtils.isEmpty((CharSequence)phone)) {
            Log.w((String)TAG, (String)("User (accountType=" + accountType + ") has no email or phone number, cannot build credential."));
            return null;
        }
        if (password == null && accountType == null) {
            Log.w((String)TAG, (String)"User has no accountType or password, cannot build credential.");
            return null;
        }
        Credential.Builder builder = new Credential.Builder(TextUtils.isEmpty((CharSequence)email) ? phone : email).setName(user.getDisplayName()).setProfilePictureUri(profilePictureUri);
        if (TextUtils.isEmpty((CharSequence)password)) {
            builder.setAccountType(accountType);
        } else {
            builder.setPassword(password);
        }
        return builder.build();
    }

    @NonNull
    public static Credential buildCredentialOrThrow(@NonNull FirebaseUser user, @Nullable String password, @Nullable String accountType) {
        Credential credential = CredentialUtils.buildCredential(user, password, accountType);
        if (credential == null) {
            throw new IllegalStateException("Unable to build credential");
        }
        return credential;
    }
}

