/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.firebase.auth.PhoneAuthCredential;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PhoneVerification {
    private final String mNumber;
    private final PhoneAuthCredential mCredential;
    private final boolean mIsAutoVerified;

    public PhoneVerification(@NonNull String number, @NonNull PhoneAuthCredential credential, boolean verified) {
        this.mNumber = number;
        this.mCredential = credential;
        this.mIsAutoVerified = verified;
    }

    @NonNull
    public String getNumber() {
        return this.mNumber;
    }

    @NonNull
    public PhoneAuthCredential getCredential() {
        return this.mCredential;
    }

    public boolean isAutoVerified() {
        return this.mIsAutoVerified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneVerification that = (PhoneVerification)o;
        return this.mIsAutoVerified == that.mIsAutoVerified && this.mNumber.equals(that.mNumber) && this.mCredential.equals(that.mCredential);
    }

    public int hashCode() {
        int result = this.mNumber.hashCode();
        result = 31 * result + this.mCredential.hashCode();
        result = 31 * result + (this.mIsAutoVerified ? 1 : 0);
        return result;
    }

    public String toString() {
        return "PhoneVerification{mNumber='" + this.mNumber + '\'' + ", mCredential=" + this.mCredential + ", mIsAutoVerified=" + this.mIsAutoVerified + '}';
    }
}

