/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.data.model.PendingIntentRequiredException;
import com.firebase.ui.auth.data.model.PhoneNumber;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.util.data.PhoneNumberUtils;
import com.firebase.ui.auth.viewmodel.AuthViewModelBase;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.Credentials;
import com.google.android.gms.auth.api.credentials.HintRequest;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CheckPhoneHandler
extends AuthViewModelBase<PhoneNumber> {
    public CheckPhoneHandler(Application application) {
        super(application);
    }

    public void fetchCredential() {
        this.setResult(Resource.forFailure(new PendingIntentRequiredException(Credentials.getClient((Context)this.getApplication()).getHintPickerIntent(new HintRequest.Builder().setPhoneNumberIdentifierSupported(true).build()), 101)));
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode != 101 || resultCode != -1) {
            return;
        }
        Credential credential = (Credential)data.getParcelableExtra("com.google.android.gms.credentials.Credential");
        String formattedPhone = PhoneNumberUtils.formatUsingCurrentCountry(credential.getId(), (Context)this.getApplication());
        if (formattedPhone != null) {
            this.setResult(Resource.forSuccess(PhoneNumberUtils.getPhoneNumber(formattedPhone)));
        }
    }
}

