/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.ui.fieldvalidators.EmailFieldValidator;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.email.EmailLinkSignInHandler;
import com.google.android.material.textfield.TextInputLayout;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailLinkPromptEmailFragment
extends FragmentBase
implements View.OnClickListener {
    public static final String TAG = "EmailLinkPromptEmailFragment";
    private Button mNextButton;
    private ProgressBar mProgressBar;
    private EditText mEmailEditText;
    private TextInputLayout mEmailLayout;
    private EmailFieldValidator mEmailFieldValidator;
    private EmailLinkSignInHandler mHandler;
    private EmailLinkPromptEmailListener mListener;

    public static EmailLinkPromptEmailFragment newInstance() {
        EmailLinkPromptEmailFragment fragment = new EmailLinkPromptEmailFragment();
        return fragment;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fui_check_email_layout, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.mNextButton = (Button)view.findViewById(R.id.button_next);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.top_progress_bar);
        this.mNextButton.setOnClickListener((View.OnClickListener)this);
        this.mEmailLayout = (TextInputLayout)view.findViewById(R.id.email_layout);
        this.mEmailEditText = (EditText)view.findViewById(R.id.email);
        this.mEmailFieldValidator = new EmailFieldValidator(this.mEmailLayout);
        this.mEmailLayout.setOnClickListener((View.OnClickListener)this);
        this.mEmailEditText.setOnClickListener((View.OnClickListener)this);
        this.getActivity().setTitle(R.string.fui_email_link_confirm_email_header);
        TextView footerText = (TextView)view.findViewById(R.id.email_footer_tos_and_pp_text);
        PrivacyDisclosureUtils.setupTermsOfServiceFooter(this.requireContext(), this.getFlowParams(), footerText);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        if (!(activity instanceof EmailLinkPromptEmailListener)) {
            throw new IllegalStateException("Activity must implement EmailLinkPromptEmailListener");
        }
        this.mListener = (EmailLinkPromptEmailListener)activity;
        this.initHandler();
    }

    private void initHandler() {
        this.mHandler = (EmailLinkSignInHandler)new ViewModelProvider((ViewModelStoreOwner)this).get(EmailLinkSignInHandler.class);
        this.mHandler.init(this.getFlowParams());
        this.mHandler.getOperation().observe(this.getViewLifecycleOwner(), (Observer)new ResourceObserver<IdpResponse>((FragmentBase)this){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                EmailLinkPromptEmailFragment.this.mListener.onEmailPromptSuccess(response);
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                EmailLinkPromptEmailFragment.this.mEmailLayout.setError((CharSequence)e.getMessage());
            }
        });
    }

    private void validateEmailAndFinishSignIn() {
        String email = this.mEmailEditText.getText().toString();
        if (this.mEmailFieldValidator.validate(email)) {
            this.mHandler.finishSignIn(email);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.button_next) {
            this.validateEmailAndFinishSignIn();
        } else if (id2 == R.id.email_layout || id2 == R.id.email) {
            this.mEmailLayout.setError(null);
        }
    }

    @Override
    public void showProgress(int message) {
        this.mNextButton.setEnabled(false);
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mNextButton.setEnabled(true);
        this.mProgressBar.setVisibility(4);
    }

    static interface EmailLinkPromptEmailListener {
        public void onEmailPromptSuccess(IdpResponse var1);
    }
}

