/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.ui.AppCompatBase;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.ui.email.EmailLinkCrossDeviceLinkingFragment;
import com.firebase.ui.auth.ui.email.EmailLinkPromptEmailFragment;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailLinkErrorRecoveryActivity
extends AppCompatBase
implements EmailLinkPromptEmailFragment.EmailLinkPromptEmailListener,
EmailLinkCrossDeviceLinkingFragment.FinishEmailLinkSignInListener {
    private static final String RECOVERY_TYPE_KEY = "com.firebase.ui.auth.ui.email.recoveryTypeKey";

    public static Intent createIntent(Context context, FlowParameters flowParams, int flow) {
        return EmailLinkErrorRecoveryActivity.createBaseIntent(context, EmailLinkErrorRecoveryActivity.class, flowParams).putExtra(RECOVERY_TYPE_KEY, flow);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fui_activity_register_email);
        if (savedInstanceState != null) {
            return;
        }
        boolean linkingFlow = this.getIntent().getIntExtra(RECOVERY_TYPE_KEY, -1) == 116;
        FragmentBase fragment = linkingFlow ? EmailLinkCrossDeviceLinkingFragment.newInstance() : EmailLinkPromptEmailFragment.newInstance();
        this.switchFragment(fragment, R.id.fragment_register_email, "EmailLinkPromptEmailFragment");
    }

    @Override
    public void onEmailPromptSuccess(IdpResponse response) {
        this.finish(-1, response.toIntent());
    }

    @Override
    public void completeCrossDeviceEmailLinkFlow() {
        EmailLinkPromptEmailFragment fragment = EmailLinkPromptEmailFragment.newInstance();
        this.switchFragment(fragment, R.id.fragment_register_email, "CrossDeviceFragment", true, true);
    }

    @Override
    public void showProgress(@StringRes int message) {
        throw new UnsupportedOperationException("Fragments must handle progress updates.");
    }

    @Override
    public void hideProgress() {
        throw new UnsupportedOperationException("Fragments must handle progress updates.");
    }
}

