/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.ui.AppCompatBase;
import com.firebase.ui.auth.ui.email.CheckEmailFragment;
import com.firebase.ui.auth.ui.email.EmailLinkFragment;
import com.firebase.ui.auth.ui.email.RegisterEmailFragment;
import com.firebase.ui.auth.ui.email.TroubleSigningInFragment;
import com.firebase.ui.auth.ui.email.WelcomeBackPasswordPrompt;
import com.firebase.ui.auth.ui.idp.WelcomeBackIdpPrompt;
import com.firebase.ui.auth.util.data.EmailLinkPersistenceManager;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.google.android.material.textfield.TextInputLayout;
import com.google.firebase.auth.ActionCodeSettings;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailActivity
extends AppCompatBase
implements CheckEmailFragment.CheckEmailListener,
RegisterEmailFragment.AnonymousUpgradeListener,
EmailLinkFragment.TroubleSigningInListener,
TroubleSigningInFragment.ResendEmailListener {
    public static Intent createIntent(Context context, FlowParameters flowParams) {
        return EmailActivity.createBaseIntent(context, EmailActivity.class, flowParams);
    }

    public static Intent createIntent(Context context, FlowParameters flowParams, String email) {
        return EmailActivity.createBaseIntent(context, EmailActivity.class, flowParams).putExtra("extra_email", email);
    }

    public static Intent createIntentForLinking(Context context, FlowParameters flowParams, IdpResponse responseForLinking) {
        return EmailActivity.createIntent(context, flowParams, responseForLinking.getEmail()).putExtra("extra_idp_response", (Parcelable)responseForLinking);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fui_activity_register_email);
        if (savedInstanceState != null) {
            return;
        }
        String email = this.getIntent().getExtras().getString("extra_email");
        IdpResponse responseForLinking = (IdpResponse)this.getIntent().getExtras().getParcelable("extra_idp_response");
        if (email != null && responseForLinking != null) {
            AuthUI.IdpConfig emailConfig = ProviderUtils.getConfigFromIdpsOrThrow(this.getFlowParams().providers, "emailLink");
            ActionCodeSettings actionCodeSettings = (ActionCodeSettings)emailConfig.getParams().getParcelable("action_code_settings");
            EmailLinkPersistenceManager.getInstance().saveIdpResponseForLinking((Context)this.getApplication(), responseForLinking);
            boolean forceSameDevice = emailConfig.getParams().getBoolean("force_same_device");
            EmailLinkFragment fragment = EmailLinkFragment.newInstance(email, actionCodeSettings, responseForLinking, forceSameDevice);
            this.switchFragment(fragment, R.id.fragment_register_email, "EmailLinkFragment");
        } else {
            AuthUI.IdpConfig emailConfig = ProviderUtils.getConfigFromIdps(this.getFlowParams().providers, "password");
            if (emailConfig != null) {
                email = emailConfig.getParams().getString("extra_default_email");
            }
            CheckEmailFragment fragment = CheckEmailFragment.newInstance(email);
            this.switchFragment(fragment, R.id.fragment_register_email, "CheckEmailFragment");
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 104 || requestCode == 103) {
            this.finish(resultCode, data);
        }
    }

    @Override
    public void onExistingEmailUser(User user) {
        if (user.getProviderId().equals("emailLink")) {
            AuthUI.IdpConfig emailConfig = ProviderUtils.getConfigFromIdpsOrThrow(this.getFlowParams().providers, "emailLink");
            this.showRegisterEmailLinkFragment(emailConfig, user.getEmail());
        } else {
            this.startActivityForResult(WelcomeBackPasswordPrompt.createIntent((Context)this, this.getFlowParams(), new IdpResponse.Builder(user).build()), 104);
            this.setSlideAnimation();
        }
    }

    @Override
    public void onExistingIdpUser(User user) {
        this.startActivityForResult(WelcomeBackIdpPrompt.createIntent((Context)this, this.getFlowParams(), user), 103);
        this.setSlideAnimation();
    }

    @Override
    public void onNewUser(User user) {
        TextInputLayout emailLayout = (TextInputLayout)this.findViewById(R.id.email_layout);
        AuthUI.IdpConfig emailConfig = ProviderUtils.getConfigFromIdps(this.getFlowParams().providers, "password");
        if (emailConfig == null) {
            emailConfig = ProviderUtils.getConfigFromIdps(this.getFlowParams().providers, "emailLink");
        }
        if (emailConfig.getParams().getBoolean("extra_allow_new_emails", true)) {
            FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
            if (emailConfig.getProviderId().equals("emailLink")) {
                this.showRegisterEmailLinkFragment(emailConfig, user.getEmail());
            } else {
                RegisterEmailFragment fragment = RegisterEmailFragment.newInstance(user);
                ft.replace(R.id.fragment_register_email, (Fragment)fragment, "RegisterEmailFragment");
                if (emailLayout != null) {
                    String emailFieldName = this.getString(R.string.fui_email_field_name);
                    ViewCompat.setTransitionName((View)emailLayout, (String)emailFieldName);
                    ft.addSharedElement((View)emailLayout, emailFieldName);
                }
                ft.disallowAddToBackStack().commit();
            }
        } else {
            emailLayout.setError((CharSequence)this.getString(R.string.fui_error_email_does_not_exist));
        }
    }

    @Override
    public void onTroubleSigningIn(String email) {
        TroubleSigningInFragment troubleSigningInFragment = TroubleSigningInFragment.newInstance(email);
        this.switchFragment(troubleSigningInFragment, R.id.fragment_register_email, "TroubleSigningInFragment", true, true);
    }

    @Override
    public void onClickResendEmail(String email) {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            this.getSupportFragmentManager().popBackStack();
        }
        AuthUI.IdpConfig emailConfig = ProviderUtils.getConfigFromIdpsOrThrow(this.getFlowParams().providers, "emailLink");
        this.showRegisterEmailLinkFragment(emailConfig, email);
    }

    @Override
    public void onSendEmailFailure(Exception e) {
        this.finishOnDeveloperError(e);
    }

    @Override
    public void onDeveloperFailure(Exception e) {
        this.finishOnDeveloperError(e);
    }

    private void finishOnDeveloperError(Exception e) {
        this.finish(0, IdpResponse.getErrorIntent(new FirebaseUiException(3, e.getMessage())));
    }

    private void setSlideAnimation() {
        this.overridePendingTransition(R.anim.fui_slide_in_right, R.anim.fui_slide_out_left);
    }

    private void showRegisterEmailLinkFragment(AuthUI.IdpConfig emailConfig, String email) {
        ActionCodeSettings actionCodeSettings = (ActionCodeSettings)emailConfig.getParams().getParcelable("action_code_settings");
        EmailLinkFragment fragment = EmailLinkFragment.newInstance(email, actionCodeSettings);
        this.switchFragment(fragment, R.id.fragment_register_email, "EmailLinkFragment");
    }

    @Override
    public void showProgress(@StringRes int message) {
        throw new UnsupportedOperationException("Email fragments must handle progress updates.");
    }

    @Override
    public void hideProgress() {
        throw new UnsupportedOperationException("Email fragments must handle progress updates.");
    }

    @Override
    public void onMergeFailure(IdpResponse response) {
        this.finish(5, response.toIntent());
    }
}

